import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import com.clobot.minibasic.data.devel.DevelManager
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

class DevelVM: ViewModel() {

    private val isShowMs = mutableStateOf(DevelManager.isShowSf.value)
    val isShow by isShowMs

    private val develTabListViewMs = mutableStateOf(DevelManager.develTabListViewSf.value)
    val develTabListView by develTabListViewMs

    private val develTabViewMs = mutableStateOf(DevelManager.develTabViewSf.value)
    val develTabView by develTabViewMs

    init {
        MainScope().launch {
            DevelManager.isShowSf.collect() {
                isShowMs.value = it
            }
        }
        MainScope().launch {
            DevelManager.develTabListViewSf.collect {
                develTabListViewMs.value = it
            }
        }
        MainScope().launch {
            DevelManager.develTabViewSf.collect {
                develTabViewMs.value = it
            }
        }
    }
}
