package com.clobot.minibasic.view.layer6_hidden

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.clobot.minibasic.data.HiddenManager
import kotlinx.coroutines.launch

class HiddenVM: ViewModel() {
    private val hiddenViewMs = mutableStateOf(HiddenManager.hiddenViewSf.value)
    val hiddenView by hiddenViewMs

    init {
        viewModelScope.launch {
            HiddenManager.hiddenViewSf.collect {
                hiddenViewMs.value = it
            }
        }
    }

}