package com.clobot.minibasic.view.layer5_admin

import com.clobot.minibasic.data.admin.AdminTab
import com.clobot.minibasic.data.operation.ScheduleChecker

class AdminTabListView(
    val onIsShow: (Boolean)->Unit, val adminTabArr: Array<AdminTab>, val selTab: Int, val onSelTab: (Int)->Unit
)

sealed class AdminTabView() {

    class AppUpdate(
        val version: String,
        val isAutoUpdate: Boolean, val autoUpdateStep: Int, val autoUpdateText: String, val autoUpdateSubText: String,
        val onAutoUpdate: ()->Unit, val onCancelAutoUpdate: ()->Unit,
        val onCheck: ()->Unit,
        val isDownload: Boolean, val onDownload: ()->Unit,
        val isInstall: Boolean, val onInstall: ()->Unit,
    ) : AdminTabView()

    class ResourceUpdate(
        val siteName: String,
        val onSiteName: (String) -> Unit,
        val sitePw: String,
        val onSitePw: (String) -> Unit,
        val isUpdate: Boolean, val updateText: String, val updateSubText: String,
        val onUpdate: ()->Unit,
        val onDeleteAll: ()->Unit,
    ) : AdminTabView()

    class Robot(
        val linearSpeed: Float, val onLinearSpeed: (Float) -> Unit,
        val angularSpeed: Float, val onAngularSpeed: (Float) -> Unit,
        val timeout: Int, val onTimeout: (Int) -> Unit,
        val poiArray: Array<String>,
        val usedPoiArray: Array<String>
    ) : AdminTabView()

    class Operation(
        val mode: ScheduleChecker.Mode, val onMode: (ScheduleChecker.Mode) -> Unit,
        val dayDataArr: Array<ScheduleChecker.DayData>,
        val modeTimeDataListArr: Array<MutableList<ScheduleChecker.ModeTimeData>>,
        val onSetDayData: (day: Int, ScheduleChecker.DayData) -> Unit,
        val onAddModeTimeData: (slot: Int, index: Int) -> Unit,
        val onRemoveModeTimeData: (slot: Int, index: Int) -> Unit,
        val onSetModeTimeData: (slot: Int, index: Int, ScheduleChecker.ModeTimeData)-> Unit,

    ) : AdminTabView()

    class Etc(
        val isDevelButtonShow: Boolean,
        val onIsDevelButtonShow: (Boolean) -> Unit,
        val onExit: () -> Unit,
    ) : AdminTabView()
}
