package com.clobot.minibasic.view.layer5_admin

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import com.clobot.minibasic.data.admin.AdminManager
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

class AdminVM : ViewModel() {
    private val isShowMs = mutableStateOf(AdminManager.isShowSf.value)
    val isShow by isShowMs

    private val adminTabListViewMs = mutableStateOf(AdminManager.adminTabListViewSf.value)
    val adminTabListView by adminTabListViewMs

    private val adminTabViewMs = mutableStateOf(AdminManager.adminTabViewSf.value)
    val adminTabView by adminTabViewMs

    init {
        MainScope().launch {
            AdminManager.isShowSf.collect() {
                isShowMs.value = it
            }
        }
        MainScope().launch {
            AdminManager.adminTabListViewSf.collect {
                adminTabListViewMs.value = it
            }
        }
        MainScope().launch {
            AdminManager.adminTabViewSf.collect {
                adminTabViewMs.value = it
            }
        }
    }
}