package com.clobot.minibasic.view.layer3_popup

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import com.clobot.minibasic.data.popup.PopupManager
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

class PopupVM: ViewModel() {

    private val isShowMs = mutableStateOf(PopupManager.isShowSf.value)
    val isShow by isShowMs

    private val popupViewMs = mutableStateOf(PopupManager.popupViewSf.value)
    val popupView by popupViewMs

    init {
        MainScope().launch {
            PopupManager.isShowSf.collect() {
                isShowMs.value = it
            }
        }

        MainScope().launch {
            PopupManager.popupViewSf.collect {
                popupViewMs.value = it
            }
        }
    }
}
