package com.clobot.minibasic.view.layer2_caption

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.lifecycle.ViewModel
import com.clobot.minibasic.data.caption.CaptionManager
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.launch

class CaptionVM: ViewModel() {

    private val isShowMs = mutableStateOf(CaptionManager.isShowSf.value)
    val isShow by isShowMs

    private val captionViewMs = mutableStateOf(CaptionManager.captionViewSf.value)
    val captionView by captionViewMs

    init {
        MainScope().launch {
            CaptionManager.isShowSf.collect() {
                isShowMs.value = it
            }
        }
        MainScope().launch {
            CaptionManager.captionViewSf.collect {
                captionViewMs.value = it
            }
        }
    }
}
