package com.clobot.minibasic.view.layer1_scene

import com.clobot.minibasic.data.contents.AccompanyContents
import com.clobot.minibasic.data.contents.IconInfoContents
import com.clobot.minibasic.data.contents.MenuInfoContents
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.mini.loop.move.MoveLeaveStartSceneTask
import com.clobot.minibasic.data.task.mini.loop.move.MoveNavigationStartSceneTask
import com.clobot.minibasic.data.task.mini.loop.charge.ChargeStartSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.promote.PromoteRunningSceneTask


sealed class SceneView {
    class InitStart(val version: String, val elapsedSec: Int) : SceneView()
    class InitShowFail(
        val tryCount: Int,
        val tryCountMax: Int,
        val countSec: Int,
        val onRetry: () -> Unit,
        val onStay: () -> Unit
    ) : SceneView()

    class InitStayFailed(val onRestart: () -> Unit) : SceneView()

    class MoveLeaveShowStart(val countSec: Int, val onOk: () -> Unit, val onAbort: () -> Unit) :
        SceneView()

    class MoveLeaveStart(
        val tryCount: Int,
        val tryCountMax: Int,
        val countSec: Int,
        val onPause: () -> Unit
    ) : SceneView()

    class MoveLeaveShowFail(
        val tryCount: Int,
        val tryCountMax: Int,
        val reason: MoveLeaveStartSceneTask.Result,
        val countSec: Int,
        val onRetry: () -> Unit,
        val onStay: () -> Unit,
        val onAbort: () -> Unit
    ) : SceneView()

    class MoveLeaveStayFailed(val onRestart: () -> Unit, val onAbort: () -> Unit) : SceneView()

    class MoveNavigationShowStart(
        val destPoi: String,
        val countSec: Int,
        val onOk: () -> Unit,
        val onAbort: () -> Unit
    ) : SceneView()

    class MoveNavigationStart(
        val destPoi: String,
        val tryCount: Int,
        val tryCountMax: Int,
        val countSec: Int,
        val onPause: () -> Unit
    ) : SceneView()

    class MoveNavigationShowFail(
        val destPoi: String,
        val tryCount: Int,
        val tryCountMax: Int,
        val reason: MoveNavigationStartSceneTask.Result,
        val countSec: Int,
        val onRetry: () -> Unit,
        val onAbort: () -> Unit
    ) : SceneView()

    class MoveNavigationStayFailed(
        val destPoi: String,
        val onRestart: () -> Unit,
        val onAbort: () -> Unit
    ) : SceneView()



    class ShowChangeMode(
        val mode: ModeManager.Mode,
        val batteryLevel: Int,
        val isCharging: Boolean,
        val countSec: Int,
        val onStartRest: () -> Unit,
        val onSkipRest: () -> Unit,
        val operationState: OperationManager.State
    ) : SceneView()

    class Rest(
        val batteryLevel: Int,
        val isCharging: Boolean,
        val onCharge: () -> Unit,
        val operationState: OperationManager.State
    ) : SceneView()

    class ChargeShowStart(
        val batteryLevel: Int,
        val countSec: Int,
        val onOk: () -> Unit,
        val onAbort: () -> Unit,
        val operationState: OperationManager.State
    ) : SceneView()

    class ChargeStart(
        val tryCount: Int,
        val tryCountMax: Int,
        val countSec: Int,
        val onPause: () -> Unit,
        val operationState: OperationManager.State
    ) : SceneView()

    class ChargeShowFail(
        val tryCount: Int,
        val tryCountMax: Int,
        val reason: ChargeStartSceneTask.Result,
        val countSec: Int,
        val onRetry: () -> Unit,
        val onStay: () -> Unit,
        val onAbort: () -> Unit,
        val operationState: OperationManager.State
    ) : SceneView()

    class ChargeStayFailed(
        val onRestart: () -> Unit,
        val onAbort: () -> Unit,
        val operationState: OperationManager.State
    ) : SceneView()

    class GuideHome(
        val accompanyContentsData: AccompanyContents.AccompanyContentsData?,
        val onAccompany: () -> Unit,
        val menuInfoContentsData: MenuInfoContents.MenuInfoContentsData?,
        val onMenuInfo: () -> Unit,
        val iconInfoContentsData: IconInfoContents.IconInfoContentsData?,
        val onIconInfo: () -> Unit,
    ) : SceneView()

    class GuideMoveNavigationShowFail(
        val destPoi: String,
        val tryCount: Int,
        val tryCountMax: Int,
        val reason: MoveNavigationStartSceneTask.Result,
        val countSec: Int,
        val onRetry: () -> Unit,
        val onChangeDest: () -> Unit,
        val onAbort: () -> Unit
    ) : SceneView()

    class AccompanyPlaceList(
        val page: Int,
        val placeList: List<AccompanyContents.AccompanyContentsData.Place>?,
        val onPlace: (Int, Int)-> Unit,
    ) : SceneView()
    class AccompanyPlaceInfo(
        val poi: String,
        val title: String,
        val desc: String,
        val image: String,
    ) : SceneView()

    class AccompanyComplete(
        val poi: String,
        val countSec: Int,
        val onOk: () -> Unit
    ) : SceneView()

    class MenuInfoList(
        val curIndex: Int,
        val curSubIndex: Int,
        val menuInfoContentsData: MenuInfoContents.MenuInfoContentsData?,
    ) : SceneView()

    class IconInfoList(
        val iconInfoContentsData: IconInfoContents.IconInfoContentsData?,
        val onIconInfo: (Int) -> Unit,
    ) : SceneView()
    class IconInfo(
        val iconInfo: IconInfoContents.IconInfoContentsData.IconInfo,
    ) : SceneView()

    class PromoteRunning(val movieIndex: Int, val movieList: List<String>, val onPause: ()->Unit, val onComplete: ()->Unit) : SceneView()
    class PromotePaused(
        val reason: PromoteRunningSceneTask.Result.Pause.Reason,
        val countSec: Int,
        val onRetry: () -> Unit,
        val onReset: () -> Unit
    ) : SceneView()

    /*
    class PromoteShowChangeMode(
        val countSec: Int,
        val onOk: () -> Unit,
    ) : SceneView()

     */

}
