package com.clobot.minibasic.data.update

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.flowOn
import org.apache.commons.net.ftp.FTPClient
import org.apache.commons.net.ftp.FTPFile
import org.apache.commons.net.ftp.FTPReply

class DirDownloader {
    data class DirFtpFile(val dir: String, val ftpFile: FTPFile)
    sealed class Result {
        class Success(val totalSize: Long, val dirFtpFileArr: Array<DirFtpFile>) : Result()
        class Fail(val message: String) : Result()
    }

    private fun downloadListFile(ftpClient: FTPClient, dir: String, dirFtpFileList:MutableList<DirFtpFile>, isRecursive:Boolean) : Long {
        var total = 0L
        val listFiles = ftpClient.listFiles()
        for (file in listFiles) {
            if (file.isDirectory) {
                if (isRecursive) {
                    if (ftpClient.changeWorkingDirectory(file.name)) {
                        total += downloadListFile(
                            ftpClient,
                            //"$remoteDir/${file.name}", "${dir}/${file.name}",
                            "${dir}/${file.name}",
                            dirFtpFileList,
                            true,
                        )
                        ftpClient.changeToParentDirectory()
                    }
                }
                else
                    dirFtpFileList.add(DirFtpFile(dir, file))

            } else if (file.isFile) {
                dirFtpFileList.add(DirFtpFile(dir, file))
                total += file.size
            }
        }
        return total

    }
    fun download(hostName: String, port: Int, remoteDir: String, isRecursive: Boolean) : Flow<Result> = flow {
        val ftpClient = FTPClient()
        try {
            ftpClient.connect(hostName, port)

            val reply = ftpClient.replyCode
            if (!FTPReply.isPositiveCompletion(reply))
                throw RuntimeException("isPositiveCompletion() error")

            if (!ftpClient.login("download", "password1423!!"))
                throw RuntimeException("login() error")

            ftpClient.enterLocalPassiveMode()

            ftpClient.changeWorkingDirectory(remoteDir)
            val dirFtpFileList : MutableList<DirFtpFile> = arrayListOf()
            //val totalSize = downloadListFile(ftpClient, remoteDir, "", dirFtpFileList, isRecursive)
            val totalSize = downloadListFile(ftpClient, "", dirFtpFileList, isRecursive)

            emit(Result.Success(totalSize, dirFtpFileList.toTypedArray()))

        } catch (e: Exception) {
            emit(Result.Fail(e.message!!))
        } finally {
            ftpClient.disconnect()
        }
    }.flowOn(Dispatchers.IO)

}