package com.clobot.minibasic.data.task.mini.loop.move

import com.ainirobot.coreservice.client.Definition
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.task.Task

class MoveTask(private val poi: String): Task() {

    enum class Result {
        OK, ABORT
    }

    private suspend fun leaveChargePile(): Boolean {
        while (RobotManager.isChargingSf.value!!) {

            when (MoveLeaveShowStartSceneTask().run() as MoveLeaveShowStartSceneTask.Result) {
                MoveLeaveShowStartSceneTask.Result.OK -> {}
                MoveLeaveShowStartSceneTask.Result.ABORT -> return false
            }

            for (i in 0 until Int.MAX_VALUE) {
                val res = MoveLeaveStartSceneTask(i).run() as MoveLeaveStartSceneTask.Result
                when (res) {
                    is MoveLeaveStartSceneTask.Result.Ok -> {}
                    is MoveLeaveStartSceneTask.Result.UserAbort, MoveLeaveStartSceneTask.Result.Timeout -> {}
                    is MoveLeaveStartSceneTask.Result.LeaveChargeResult -> {
                        when (val res2 = res.leaveChargePileResult) {
                            is RobotManager.LeaveChargePileResult.Result -> {}
                            is RobotManager.LeaveChargePileResult.OnResult -> {
                                if (res2.result == Definition.RESULT_OK) {
                                    return true
                                }
                            }
                        }
                    }
                }
                if (!RobotManager.isChargingSf.value!!)
                    return true

                when (MoveLeaveShowFailSceneTask(i, res).run() as MoveLeaveShowFailSceneTask.Result) {
                    MoveLeaveShowFailSceneTask.Result.RETRY -> {}
                    MoveLeaveShowFailSceneTask.Result.STAY -> {
                        when (MoveLeaveStayFailedSceneTask().run() as MoveLeaveStayFailedSceneTask.Result) {
                            MoveLeaveStayFailedSceneTask.Result.RESTART -> break
                            MoveLeaveStayFailedSceneTask.Result.ABORT -> return false
                        }

                    }
                    MoveLeaveShowFailSceneTask.Result.ABORT -> return false
                }
            }
        }
        return true
    }
    private suspend fun startNavigation(): Result {
        while (!RobotManager.isRobotInLocations(poi)) {

            when (MoveNavigationShowStartSceneTask(poi).run() as MoveNavigationShowStartSceneTask.Result) {
                MoveNavigationShowStartSceneTask.Result.OK -> {}
                MoveNavigationShowStartSceneTask.Result.ABORT -> return Result.ABORT
            }

            for (i in 0 until Int.MAX_VALUE) {
                val res = MoveNavigationStartSceneTask(poi, i).run() as MoveNavigationStartSceneTask.Result
                when (res) {
                    is MoveNavigationStartSceneTask.Result.AlreadyInLocation -> return Result.OK
                    is MoveNavigationStartSceneTask.Result.UserAbort, MoveNavigationStartSceneTask.Result.Timeout -> {}
                    is MoveNavigationStartSceneTask.Result.NotExistPoi -> {}
                    is MoveNavigationStartSceneTask.Result.StartNavigationResultResult -> {
                        when (val res2 = res.startNavigationResult) {
                            is RobotManager.StartNavigationResult.Result -> {}
                            is RobotManager.StartNavigationResult.OnError -> {}
                            is RobotManager.StartNavigationResult.OnResult -> {
                                if (res2.status == Definition.RESULT_OK) {
                                    return Result.OK
                                }
                            }
                        }
                    }
                }

                when (MoveNavigationShowFailSceneTask(poi, i, res).run() as MoveNavigationShowFailSceneTask.Result) {
                    MoveNavigationShowFailSceneTask.Result.RETRY -> {}
                    /*
                    MoveNavigationShowFailSceneTask.Result.STAY -> {
                        when (MoveNavigationStayFailedSceneTask(poi).run() as MoveNavigationStayFailedSceneTask.Result) {
                            MoveNavigationStayFailedSceneTask.Result.RESTART -> break
                            MoveNavigationStayFailedSceneTask.Result.ABORT -> return false
                        }
                    }
                     */
                    MoveNavigationShowFailSceneTask.Result.ABORT -> return Result.ABORT
                    //MoveNavigationShowFailSceneTask.Result.CHANGE_DEST -> return Result.CHANGE_DEST
                }
            }
        }
        return Result.OK
    }
    override suspend fun onRun(): Result {
        return if (leaveChargePile())
            startNavigation()
        else
            Result.ABORT
    }
}