package com.clobot.minibasic.data.task.mini.loop.move

import androidx.compose.runtime.Composable
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import com.clobot.minibasic.R
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.mini.SystemButton1
import com.clobot.minibasic.data.task.mini.SystemButton2
import com.clobot.minibasic.data.task.mini.SystemCompose
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch

class MoveNavigationStayFailedSceneTask(private val destPoi: String) : SceneTask() {
    enum class Result {
        RESTART, ABORT,
    }

    private val resultChannel = Channel<Result>()

    override suspend fun onRun(): Result {
        return coroutineScope {
            setSceneView(SceneView.MoveNavigationStayFailed(destPoi, { onRestart() }, { onAbort() }))
            resultChannel.receive()
        }
    }
    private fun onRestart() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.RESTART)
        }
    }
    private fun onAbort() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.ABORT)
        }
    }
}

@Composable
fun MoveNavigationStayFailedSceneScreen(sceneView: SceneView.MoveNavigationStayFailed) {
    MiniImageBg(R.drawable.scene_charge_show_fail_bg) {

        SystemMainText(text = buildAnnotatedString {
            withStyle(SpanStyle(SystemCompose.highlightTextColor)) {
                append(sceneView.destPoi)
            }
            append("(으)로 이동하는데 실패하여 대기합니다.")
        })

        SystemButton1(
            onClick = sceneView.onRestart,
            text = "재시작"
        )
        SystemButton2(
            onClick = sceneView.onAbort,
            text = "취소"
        )
    }
}
