package com.clobot.minibasic.data.task.mini.loop.move

import android.widget.VideoView
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.viewinterop.AndroidView
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.SetupManger
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniTextImageButton
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.mini.SystemCompose
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch

class MoveNavigationShowStartSceneTask(private val destPoi: String) : SceneTask() {
    enum class Result {
        OK, ABORT,
    }

    private val resultChannel = Channel<Result>()

    override val timeoutSec: Int = SetupManger.Open.Move.navigationShowStartSceneTimeoutSec

    override suspend fun onRun() : Result {
        return coroutineScope {
            val countJob = launch {
                runCountJob() {
                    updateView()
                }
                resultChannel.send(Result.OK)
            }
            val ttsJob = launch {
                RobotManager.playText("${destPoi}로 이동합니다.", SetupManger.Robot.playTextMediumVolume)
            }
            try {

                resultChannel.receive()
            } finally {
                countJob.cancel()
                ttsJob.cancel()
            }
        }
    }
    private fun updateView() {
        setSceneView(
            SceneView.MoveNavigationShowStart(
                destPoi,
                countSec,
                { onOk() },
                { onAbort() },
            )
        )
    }
    private fun onOk() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.OK)
        }
    }
    private fun onAbort() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.ABORT)
        }
    }
}

@Composable
fun MoveNavigationShowStartSceneScreen(sceneView: SceneView.MoveNavigationShowStart) {
    Box(Modifier.lp(0, 0, MiniCompose.bg_width, MiniCompose.bg_height)) {
        val videoPath =
            "android.resource://${LocalContext.current.packageName}/${R.raw.move_mp4}"
        AndroidView(
            modifier = Modifier.fillMaxSize(),
            factory = { mContext ->
                VideoView(mContext).apply {
                    setVideoPath(videoPath)
                    setOnPreparedListener { mediaPlayer ->
                        mediaPlayer.isLooping = true
                    }
                    start()
                }
            }
        )
        SystemMainText(text = buildAnnotatedString {
            withStyle(SpanStyle(SystemCompose.highlightTextColor)) {
                append(sceneView.destPoi)
            }
            append("(으)로 이동합니다.\n")
        })

        MiniTextImageButton(702, 871, 516, 132, R.drawable.scene_common_ok_btn,
            "확인(${sceneView.countSec})", SystemCompose.textColor, SystemCompose.largeButtonFontSize,
            { sceneView.onOk() }
        )

    }
}
