package com.clobot.minibasic.data.task.mini.loop.move

import androidx.compose.runtime.Composable
import com.clobot.minibasic.R
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.mini.SystemButton1
import com.clobot.minibasic.data.task.mini.SystemButton2
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.data.task.mini.SystemSubText
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch

class MoveLeaveStayFailedSceneTask : SceneTask() {
    enum class Result {
        RESTART, ABORT,
    }

    private val resultChannel = Channel<Result>()
    override suspend fun onRun(): Result {
        return coroutineScope {
            setSceneView(SceneView.MoveLeaveStayFailed({ onRestart() }, { onAbort() }))
            resultChannel.receive()
        }
    }
    private fun onRestart() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.RESTART)
        }
    }
    private fun onAbort() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.ABORT)
        }
    }
}

@Composable
fun MoveLeaveStayFailedSceneScreen(sceneView: SceneView.MoveLeaveStayFailed) {
    MiniImageBg(R.drawable.scene_charge_show_fail_bg) {
        SystemMainText("충전기에서 나오는데 실패하여 대기합니다.")

        SystemButton1(
            onClick = sceneView.onRestart,
            text = "재시작"
        )
        SystemButton2(
            onClick = sceneView.onAbort,
            text = "취소"
        )
        SystemSubText("반복적으로 실패시, 손으로 로봇을 잡아 당겨서 로봇과 충전대를 분리시키세요.")
    }
}
