package com.clobot.minibasic.data.task.mini.loop.mode.rest

import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.task.Task
import com.clobot.minibasic.data.task.mini.loop.charge.ChargeTask
import com.clobot.minibasic.data.task.mini.loop.mode.ShowChangeModeSceneTask

class RestTask: Task() {
    override suspend fun onRun() {
        while (true) {
            ChargeTask().run()
            while (true) {
                when (val res = RestSceneTask().run() as RestSceneTask.Result) {
                    is RestSceneTask.Result.ChangeMode -> {
                        when (ShowChangeModeSceneTask(res.mode).run() as ShowChangeModeSceneTask.Result) {
                            ShowChangeModeSceneTask.Result.OK -> {
                                ModeManager.setMode(res.mode)
                                return
                            }
                            ShowChangeModeSceneTask.Result.SKIP -> {
                                ModeManager.setExtendTime()
                            }
                        }
                    }
                    is RestSceneTask.Result.Charge -> break
                }
            }
        }
    }
}