package com.clobot.minibasic.data.task.mini.loop.mode.rest

import androidx.compose.runtime.Composable
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.mini.SystemButton1
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class RestSceneTask : SceneTask() {

    private fun updateView() {
        setSceneView(
            SceneView.Rest(
                RobotManager.batteryLevelSf.value ?: 0,
                RobotManager.isChargingSf.value == true,
                {onCharge()},
                OperationManager.stateSf.value!!,
            )
        )
    }

    sealed class Result {
        class ChangeMode(val mode: ModeManager.Mode) : Result()
        data object Charge : Result()
    }

    val resultChannel = Channel<Result>()

    override suspend fun onRun(): Result {
        return coroutineScope {
            val countJob = launch {
                runCountJob() {
                    updateView()
                }
            }
            val operationJob = launch {
                OperationManager.stateSf.collect() {
                    updateView()
                }
            }
            val chargingJob = launch {
                RobotManager.isChargingSf.collect() {
                    updateView()
                }
            }
            val operationCheckerJob = launch {
                while(true) {
                    if (OperationManager.stateSf.value?.mode != ModeManager.Mode.REST) {
                        if (!ModeManager.isExtend)
                            resultChannel.send(Result.ChangeMode(OperationManager.stateSf.value?.mode!!))
                    }
                    delay(500)
                }
            }

            try {
                //delay(1000 * 3)

                resultChannel.receive()
            } finally {
                operationCheckerJob.cancel()
                chargingJob.cancel()
                operationJob.cancel()
                countJob.cancel()
            }
        }
    }
    override fun onPause(isPause: Boolean) {
        if (!isPause)
            ModeManager.resetExtendTime()
    }

    private fun onCharge() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.Charge)
        }
    }
}


@Composable
fun RestSceneScreen(sceneView: SceneView.Rest) {
    MiniImageBg(R.drawable.scene_rest) {
        SystemMainText("휴식 중입니다.")

        RestChargeBatteryLevel(sceneView.batteryLevel, sceneView.isCharging)

        if (!sceneView.isCharging)
            SystemButton1("충전하기", sceneView.onCharge)
        RestOperationStateView(sceneView.operationState)
    }
}

