package com.clobot.minibasic.data.task.mini.loop.mode.rest

import android.annotation.SuppressLint
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.LinearProgressIndicator
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.draw.scale
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.R
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.operation.ScheduleChecker
import com.clobot.minibasic.data.operation.SystemChecker
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.MiniFitText
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpToSp

@Composable
fun RestChargeBatteryLevel(batteryLevel: Int, isCharging: Boolean) {
    val x = 821
    val y = 186
    Box(Modifier.lp(x + 16, y + 8, 87, 40)) {
        Box(
            modifier = Modifier
                .fillMaxSize()
                .scale(scaleX = -1f, scaleY = 1f),
            contentAlignment = Alignment.Center,
        ) {
            LinearProgressIndicator(
                modifier = Modifier
                    .fillMaxSize()
                    .clip(RoundedCornerShape(2.dp))
                    .align(Alignment.Center),
                progress = batteryLevel / 100f,
                color = if (batteryLevel > 20) Color.White else Color.Red,
                trackColor = Color.Transparent,
            )
        }
    }
    if (isCharging) {
        MiniImage(R.drawable.scene_rest_charging, modifier = Modifier.lp(x + 51, y + 11, 19, 34))
    }
    MiniFitText(x + 137, y + 6, 138, 43, "${batteryLevel}%", if (batteryLevel >= 20) Color.White else Color.Red, 48)
}

@SuppressLint("DefaultLocale")
@Composable
fun RestOperationStateView(operationState: OperationManager.State) {
    val text = buildAnnotatedString {
        append( when(operationState.mode) {
            ModeManager.Mode.REST -> "휴식 중."
            ModeManager.Mode.GUIDE -> "안내 중."
            ModeManager.Mode.PROMOTE -> "홍보 중."
        })
        if (operationState.systemState.isRest) {
            when (val systemState = operationState.systemState) {
                is SystemChecker.State.LowBattery -> {
                    append("(배터리가 너무 낮습니다. ")
                    withStyle(
                        SpanStyle(Color.Yellow)
                    ) {
                        append(systemState.lowBatteryLevelRange.first.toString())
                    }
                    append(" 미만.  ")
                    withStyle(
                        SpanStyle(Color.Yellow)
                    ) {
                        append(systemState.lowBatteryLevelRange.last.toString())
                    }
                    append(" 까지 충전 필요)")
                }
            }
        }
        else {
            when (val scheduleState = operationState.scheduleState) {
                is ScheduleChecker.State.AlwaysRest -> append(" (항상 휴식)")
                is ScheduleChecker.State.AlwaysGuide -> append(" (항상 안내)")
                is ScheduleChecker.State.AlwaysPromote -> append(" (항상 홍보)")
                is ScheduleChecker.State.ScheduleDayRest -> append(" (스케쥴 요일별 휴식)")
                is ScheduleChecker.State.Schedule -> {
                    append(
                    when(scheduleState.mode) {
                        ModeManager.Mode.REST -> "(휴식 중)"
                        ModeManager.Mode.GUIDE -> "(안내 중)"
                        ModeManager.Mode.PROMOTE -> "(홍보 중)"
                    })
                    withStyle(SpanStyle(Color.Yellow)) {
                        val hour = scheduleState.lastTime / 3600
                        val minute = (scheduleState.lastTime / 60) % 60
                        append("  ${String.format("%02d", hour)}:${String.format("%02d", minute)}까지")
                    }

                }
            }
        }
        /*
        else if (!operationState.isOpen) {
            when (val scheduleState = operationState.scheduleState) {
                is ScheduleChecker.State.AlwaysClose -> append(" (항상 휴식)")
                is ScheduleChecker.State.AlwaysOpen -> append(" (항상 운영)")
                is ScheduleChecker.State.Daily -> {
                    append(" (1일별 운영: ")
                    withStyle(SpanStyle(Color.Yellow)) {
                        append("${String.format("%02d", scheduleState.dailyTimeRange.first / 2)}:"
                                + String.format("%02d", (scheduleState.dailyTimeRange.first % 2) * 30)
                        )
                    }
                    append(" ~ ")
                    withStyle(SpanStyle(Color.Yellow)) {
                        append("${String.format("%02d", scheduleState.dailyTimeRange.last / 2)}:"
                                + String.format("%02d", (scheduleState.dailyTimeRange.last % 2) * 30)
                        )
                    }
                    append(")")
                }
                is ScheduleChecker.State.Weekly -> {
                    append(" (1주일별 운영: ")
                    withStyle(SpanStyle(Color.Yellow)) {
                        append("${scheduleState.dayOfWeek + 1}요일 ")
                    }
                    withStyle(SpanStyle(Color.Yellow)) {
                        append("${String.format("%02d", scheduleState.dayOfWeekTimeData.timeRange.first / 2)}:"
                                + String.format("%02d", (scheduleState.dayOfWeekTimeData.timeRange.first % 2) * 30)
                        )
                    }
                    append(" ~ ")
                    withStyle(SpanStyle(Color.Yellow)) {
                        append("${String.format("%02d", scheduleState.dayOfWeekTimeData.timeRange.last / 2)}:"
                                + String.format("%02d", (scheduleState.dayOfWeekTimeData.timeRange.last % 2) * 30)
                        )
                    }
                    append(")")
                }

                is ScheduleChecker.State.TenMinutely -> {
                    append(" (10분별 운영: ")

                    append("   운영 시간: ")
                    withStyle(SpanStyle(Color.Yellow)) {
                        append(scheduleState.tenMinutelyTimeRange.first.toString())
                    }
                    append("분 ~ ")
                    withStyle(SpanStyle(Color.Yellow)) {
                        append(scheduleState.tenMinutelyTimeRange.last.toString())
                    }
                    append("분  (10분 마다 ")
                    withStyle(SpanStyle(Color.Yellow)) {
                        append((scheduleState.tenMinutelyTimeRange.last - scheduleState.tenMinutelyTimeRange.first).toString())
                    }
                    append("분 운영))")
                }
            }
        }

         */
    }
    Box(Modifier.lp(10, MiniCompose.bg_height - 80, 1900, 80)) {
        MiniText(
            text,
            modifier = Modifier
                .fillMaxSize()
                .wrapContentSize(Alignment.CenterStart),
            Color.White,
            lpToSp(30),
        )
    }
}
