package com.clobot.minibasic.data.task.mini.loop.mode.promote

import com.clobot.minibasic.data.SetupManger
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.mode.PromoteModeManager
import com.clobot.minibasic.data.task.Task
import com.clobot.minibasic.data.task.mini.loop.mode.ShowChangeModeSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.GuideTask
import com.clobot.minibasic.data.task.mini.loop.move.MoveTask
import kotlinx.coroutines.delay

class PromoteTask : Task() {

    override suspend fun onRun() {

        while (true) {
            MoveTask(SetupManger.Open.Move.initPosPoi).run()
            while (true) {
                PromoteModeManager.index = 0
                when (val res = PromoteRunningSceneTask().run() as PromoteRunningSceneTask.Result) {
                    is PromoteRunningSceneTask.Result.Pause -> {
                        PromotePausedSceneTask(res.reason).run()
                    }
                    is PromoteRunningSceneTask.Result.ModeChange -> {
                        when (ShowChangeModeSceneTask(res.mode).run() as ShowChangeModeSceneTask.Result) {
                            ShowChangeModeSceneTask.Result.OK -> {
                                ModeManager.setMode(res.mode)
                                return
                            }
                            ShowChangeModeSceneTask.Result.SKIP -> {
                                ModeManager.setExtendTime()
                            }
                        }
                    }
                }
            }
        }
    }
}