package com.clobot.minibasic.data.task.mini.loop.mode.promote

import android.os.Environment
import android.widget.VideoView
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.viewinterop.AndroidView
import com.ainirobot.coreservice.client.Definition
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.SetupManger
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.mode.PromoteModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.MiniBlackBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch


class PromoteRunningSceneTask() : SceneTask() {
    sealed class Result {

        class Pause(val reason: Reason) : Result() {
            sealed class Reason {
                class StartNavigationError(val poi: String, val reason: RobotManager.StartNavigationResult) : Reason()

                data object Charging : Reason()
                data object User : Reason()
            }
        }
        class ModeChange(val mode: ModeManager.Mode) : Result()
    }

    private val resultChannel = Channel<Result>()

    override fun onPause(isPause: Boolean) {
        if (isPause)
            onPause()

    }

    override fun onBegin() {
        CaptionManager.setIsShow(false)
    }

    override fun onEnd() {
        CaptionManager.setIsShow(true)
        RobotManager.stopNavigation()
    }

    override suspend fun onRun(): Result {
        return coroutineScope {
            val operationJob = launch {
                while(true) {
                    if (OperationManager.stateSf.value?.mode != ModeManager.Mode.PROMOTE) {
                        if (!ModeManager.isExtend)
                            resultChannel.send(Result.ModeChange(OperationManager.stateSf.value?.mode!!))
                    }
                    delay(500)
                }
            }
            val patrolJob = launch {
                if (ContentsManager.promoteContents.promoteContentsData != null) {
                    while (true) {

                        delay(ContentsManager.promoteContents.promoteContentsData!!.staySec * 1000L)


                        if (PromoteModeManager.index >= 0 && PromoteModeManager.index < ContentsManager.promoteContents.promoteContentsData!!.poiList.size) {
                            val poi =
                                ContentsManager.promoteContents.promoteContentsData!!.poiList[PromoteModeManager.index]

                            if (!RobotManager.isRobotInLocations(poi)) {
                                if (RobotManager.isChargingSf.value == true)
                                    resultChannel.send(Result.Pause(Result.Pause.Reason.Charging))
                                else {
                                    val res = RobotManager.startNavigation(
                                        poi,
                                        SetupManger.Robot.startNavigationTimeoutSec * 1000L,
                                        SetupManger.Robot.startNavigationLinearSpeed.toDouble(),
                                        SetupManger.Robot.startNavigationAngularSpeed.toDouble(),
                                    )
                                    when (res) {
                                        is RobotManager.StartNavigationResult.Result ->
                                            resultChannel.send(
                                                Result.Pause(
                                                    Result.Pause.Reason.StartNavigationError(
                                                        poi,
                                                        res
                                                    )
                                                )
                                            )

                                        is RobotManager.StartNavigationResult.OnResult -> {
                                            if (res.status != Definition.RESULT_OK)
                                                resultChannel.send(
                                                    Result.Pause(
                                                        Result.Pause.Reason.StartNavigationError(
                                                            poi,
                                                            res
                                                        )
                                                    )
                                                )
                                        }

                                        is RobotManager.StartNavigationResult.OnError ->
                                            resultChannel.send(
                                                Result.Pause(
                                                    Result.Pause.Reason.StartNavigationError(
                                                        poi,
                                                        res
                                                    )
                                                )
                                            )
                                    }
                                }
                            }

                            if (ContentsManager.promoteContents.promoteContentsData!!.poiList.size > 0)
                                PromoteModeManager.index =
                                    (PromoteModeManager.index + 1) % ContentsManager.promoteContents.promoteContentsData!!.poiList.size
                            else
                                PromoteModeManager.index = 0
                        }
                    }
                }
            }

            updateView()

            try {
                resultChannel.receive()
            } finally {
                patrolJob.cancel()
                operationJob.cancel()
            }
        }
    }

    private var videoIndex = 0
    private fun updateView() {
        setSceneView(
            SceneView.PromoteRunning(videoIndex, ContentsManager.promoteContents.promoteContentsData?.movieList ?: emptyList(), onPause = {onPause()}, onComplete = {})
        )
    }
    private fun onPause() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.Pause(Result.Pause.Reason.User))
        }
    }

}

@Composable
fun PromoteRunningSceneScreen(sceneView: SceneView.PromoteRunning) {
    var index by remember {
        mutableIntStateOf(sceneView.movieIndex)
    }
    MiniBlackBg {

    }
    val appName = stringResource(R.string.app_name)
    AndroidView(
        modifier = Modifier
            .fillMaxSize()
            .clickable { sceneView.onPause() }
            ,
        factory = { context ->
            VideoView(context).apply {
                setVideoPath(Environment.getExternalStorageDirectory().path + "/$appName/${sceneView.movieList[index]}")
                setOnPreparedListener { mediaPlayer ->
                    mediaPlayer.isLooping = false
                }
                setOnCompletionListener {
                    index = (index + 1) % sceneView.movieList.size
                    setVideoPath(Environment.getExternalStorageDirectory().path + "/$appName/${sceneView.movieList[index]}")
                    start()
                }
                start()
            }
        }
    )
}
