package com.clobot.minibasic.data.task.mini.loop.mode.promote

import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.mode.PromoteModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.data.task.mini.SystemButton1
import com.clobot.minibasic.data.task.mini.SystemButton2
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.data.task.mini.loop.mode.promote.PromoteRunningSceneTask
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class PromotePausedSceneTask(private val reason: PromoteRunningSceneTask.Result.Pause.Reason) : SceneTask() {

    private val resultChannel = Channel<Unit>()

    override val timeoutSec: Int = PromoteModeManager.promotePausedSceneTaskTimeoutSec
    override suspend fun onRun() {
        return coroutineScope {
            val countJob = launch {
                runCountJob() {
                    updateView()
                }
                resultChannel.send(Unit)
            }
            val operationJob = launch {
                while(true) {
                    if (OperationManager.stateSf.value?.mode != ModeManager.Mode.PROMOTE) {
                        if (!ModeManager.isExtend)
                            resultChannel.send(Unit)
                    }
                    delay(500)
                }
            }

            try {
                resultChannel.receive()
            } finally {
                operationJob.cancel()
                countJob.cancel()
            }
        }
    }

    private fun updateView() {
        setSceneView(
            SceneView.PromotePaused(
                reason,
                countSec,
                { onRetry() },
                { onAbort() },
            )
        )
    }
    private fun onRetry() {
        taskCoroutineScope?.launch { resultChannel.send(Unit) }
    }
    private fun onAbort() {
        resetElapseSec()
    }

}
@Composable
fun PromotePausedSceneScreen(sceneView: SceneView.PromotePaused) {
    MiniImageBg(R.drawable.scene_charge_show_fail_bg) {
        SystemMainText(text = buildAnnotatedString {

            append("잠시 멈춥니다..\n")

            withStyle(
                SpanStyle(Color.Red, lpToSp(50))
            ) {
                val msg = when (val reason = sceneView.reason) {
                    is PromoteRunningSceneTask.Result.Pause.Reason.User -> "사용자 취소"
                    is PromoteRunningSceneTask.Result.Pause.Reason.Charging -> "이동 불가 (충전 중)"
                    is PromoteRunningSceneTask.Result.Pause.Reason.StartNavigationError -> {
                        when (val reason2 = reason.reason) {
                            is RobotManager.StartNavigationResult.Result -> "이동 실패:${reason.poi}\nResult: (${reason2.result})"
                            is RobotManager.StartNavigationResult.OnResult -> "이동 실패:${reason.poi}\nOnResult: (${reason2.status}, ${reason2.responseString})"
                            is RobotManager.StartNavigationResult.OnError -> "이동 실패:${reason.poi}\nOnError: (${reason2.errorCode}, ${reason2.errorString})"
                        }
                    }

                }
                append(msg)
            }
        })

        SystemButton1(
            "재시도" + "(${sceneView.countSec})",
            sceneView.onRetry
        )
        SystemButton2(
            "시간 연장",
            sceneView.onReset,
        )
    }

}