package com.clobot.minibasic.data.task.mini.loop.mode.guide.menu_info

import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.alpha
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.task.MiniBlackBg
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpOffset
import com.clobot.minibasic.data.task.lpSize
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.data.task.lpWToDpW
import com.clobot.minibasic.data.task.mini.SystemCompose
import com.clobot.minibasic.data.task.mini.loop.mode.guide.ContentsSceneTask
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class MenuInfoListSceneTask: ContentsSceneTask() {
    override fun updateView() {
        setSceneView(
            SceneView.MenuInfoList(
                -1,
                0,
                ContentsManager.menuInfoContents.menuInfoContentsData,
            )
        )
    }
}
@Composable
fun MenuInfoListSceneScreen(sceneView: SceneView.MenuInfoList) {
    MiniBlackBg {
        MiniImage(R.drawable.scene_menu_info_list_bg, Modifier.lp(64, 160, 368, 872))

        var selIndex by remember { mutableIntStateOf(-1) }
        var selSubIndex by remember { mutableIntStateOf(-1) }
        var selImageIndex by remember { mutableIntStateOf(-1) }

        LazyColumn(
            Modifier
                .lp(64, 160, 368, 872)
                .padding(lpWToDpW(20), lpWToDpW(20))
                .border(MiniCompose.debugBorder), horizontalAlignment = Alignment.CenterHorizontally) {
            if (sceneView.menuInfoContentsData != null) {
                sceneView.menuInfoContentsData.menuInfoList.forEachIndexed { i, menuInfoInfo ->
                    item {
                        Box(
                            Modifier
                                .lpSize(320, 100 + 20)
                                .wrapContentSize()
                                .clickable {
                                    selIndex = i
                                    selSubIndex = -1
                                    selImageIndex = 0
                                }) {
                            MiniImage(R.drawable.scene_menu_info_list_menu_bar, Modifier.lpSize(320, 100))
                            if (i == selIndex)
                                MiniImage(R.drawable.scene_menu_info_list_sel_menu_bar, Modifier.lpSize(320, 100))

                            MiniText(
                                sceneView.menuInfoContentsData.menuInfoList[i].name,
                                Modifier
                                    .lpSize(320, 100)
                                    .wrapContentSize(),
                                SystemCompose.textColor,
                                lpToSp(
                                    36
                                )
                            )
                        }
                    }
                    if (i == selIndex) {
                        menuInfoInfo.subMenuInfoArr.forEachIndexed { j, subMenuInfoInfoItem ->
                            item {
                                Box(
                                    Modifier
                                        .lpOffset(30 / 2, 0)
                                        .lpSize(320, 100)
                                        .wrapContentSize()
                                        .clickable {
                                            selSubIndex = j
                                            selImageIndex = 0
                                        }) {

                                    MiniImage(R.drawable.scene_menu_info_list_sub_menu_bar,
                                        Modifier.lpSize(287, 90))
                                    if (j == selSubIndex)
                                        MiniImage(R.drawable.scene_menu_info_list_sel_sub_menu_bar,
                                            Modifier.lpSize(287, 90))

                                    val nameArr = subMenuInfoInfoItem.name.split("/")

                                    MiniText(
                                        buildAnnotatedString {
                                            nameArr.forEach {
                                                if (it.startsWith("h")) {
                                                    withStyle(SpanStyle(SystemCompose.highlightTextColor)) {
                                                        append(it.drop(1))
                                                    }
                                                }
                                                else
                                                    append(it)
                                            }
                                        }
                                        ,
                                        Modifier
                                            .lpSize(287, 90)
                                            .wrapContentSize(),
                                        SystemCompose.textColor,
                                        lpToSp(
                                            22
                                        )
                                    )

                                }
                            }
                        }
                    }
                }
            }
        }



        if (sceneView.menuInfoContentsData != null) {

            val text = if (selIndex >= 0) {
                if (selSubIndex >= 0) {
                    if (sceneView.menuInfoContentsData.menuInfoList[selIndex].subMenuInfoArr[selSubIndex].imageArr.isNotEmpty())
                        sceneView.menuInfoContentsData.menuInfoList[selIndex].subMenuInfoArr[selSubIndex].imageArr[selImageIndex]
                    else
                        "empty"
                }
                else {
                    if (sceneView.menuInfoContentsData.menuInfoList[selIndex].imageArr.isNotEmpty())
                        sceneView.menuInfoContentsData.menuInfoList[selIndex].imageArr[selImageIndex]
                    else
                        "empty"
                }
            } else
                "not select"

            MiniText(text,
                Modifier
                    .lp(603, 272, 1150, 647)
                    .wrapContentSize(), Color.White, lpToSp(80))

            val imageCount =
                if (selIndex >= 0) {
                    if (selSubIndex >= 0)
                        sceneView.menuInfoContentsData.menuInfoList[selIndex].subMenuInfoArr[selSubIndex].imageArr.size
                    else
                        sceneView.menuInfoContentsData.menuInfoList[selIndex].imageArr.size
                } else
                    0

            if (imageCount > 0) {

                if (selImageIndex - 1 >= 0)
                    MiniImage(R.drawable.scene_menu_info_list_menu_prev_btn,
                        Modifier
                            .lp(464, 547, 97, 97)
                            .clickable { selImageIndex-- })
                else
                    MiniImage(R.drawable.scene_menu_info_list_menu_prev_btn,
                        Modifier
                            .lp(464, 547, 97, 97)
                            .alpha(0.4f))

                if (selImageIndex + 1 < imageCount)
                    MiniImage(R.drawable.scene_menu_info_list_menu_next_btn,
                        Modifier
                            .lp(1794, 547, 97, 97)
                            .clickable { selImageIndex++ })
                else
                    MiniImage(R.drawable.scene_menu_info_list_menu_next_btn,
                        Modifier
                            .lp(1794, 547, 97, 97)
                            .alpha(0.4f))


                LazyRow(
                    Modifier
                        .lp(603, 951, 1150, 16)
                        .wrapContentSize(),
                    horizontalArrangement = Arrangement.spacedBy(lpWToDpW(10)) , verticalAlignment = Alignment.CenterVertically
                ) {
                    repeat(imageCount) {
                        item {
                            val resId = if (it == selImageIndex) R.drawable.scene_accompany_place_list_cur_page_btn else R.drawable.scene_accompany_place_list_page_btn


                            MiniImage(resId, Modifier
                                .lpSize(16, 16)
                                .border(MiniCompose.debugBorder)
                                .clickable {
                                    selImageIndex = it
                                })

                        }
                    }
                }
            }
        }

    }
}
