package com.clobot.minibasic.data.task.mini.loop.mode.guide.icon_info

import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.part.NaviCaptionPart
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.task.MiniBlackBg
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpSize
import com.clobot.minibasic.data.task.lpWToDpW
import com.clobot.minibasic.data.task.mini.loop.mode.guide.ContentsSceneTask
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class IconInfoListSceneTask: SceneTask() {

    sealed class Result {
        class IconInfo(val index: Int): Result()
        data object Back: Result()
        data object Home: Result()
    }
    val resultChannel = Channel<Result>()

    override fun onBegin() {
        super.onBegin()

        CaptionManager.naviCaptionPart.isShow = true

    }
    override fun onEnd() {
        super.onEnd()
        CaptionManager.naviCaptionPart.isShow = false
    }


    override val timeoutSec = 100

    private fun updateView() {
        setSceneView(
            SceneView.IconInfoList(
                ContentsManager.iconInfoContents.iconInfoContentsData,
                onIconInfo = { onIconInfo(it) },
            )
        )
    }

    override suspend fun onRun(): Result {
        return coroutineScope {
            val navigationJobCaptionJob = launch {
                when (CaptionManager.naviCaptionPart.receive()) {
                    NaviCaptionPart.Result.BACK -> resultChannel.send(Result.Back)
                    NaviCaptionPart.Result.HOME -> resultChannel.send(Result.Home)
                }
            }
            val countJob = launch {
                if (RobotManager.isPersonSf.value == null) {
                    runCountJob {
                        updateView()
                    }
                    resultChannel.send(Result.Home)
                }
            }
            val personCheckJob = launch {
                if (RobotManager.isPersonSf.value != null) {
                    var noPersonCountSec = 0
                    while (true) {
                        if (RobotManager.isPersonSf.value!!)
                            noPersonCountSec = 0
                        else
                            noPersonCountSec++
                        delay(1000)

                        if (noPersonCountSec > 5)
                            break
                    }
                    resultChannel.send(Result.Home)
                }
            }

            updateView()

            try {
                resultChannel.receive()
            } finally {
                countJob.cancel()
                personCheckJob.cancel()
                navigationJobCaptionJob.cancel()
            }
        }
    }

    private fun onIconInfo(index: Int) {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.IconInfo(index))
        }
    }
}
@Composable
fun IconInfoListSceneScreen(sceneView: SceneView.IconInfoList) {
    MiniBlackBg {
        MiniImageBg(R.drawable.scene_home_bg) {
            if (sceneView.iconInfoContentsData != null) {
                LazyRow(
                    Modifier
                        .lp(10, 395, MiniCompose.bg_width - 20, 414).wrapContentSize()
                        .border(MiniCompose.debugBorder),
                    horizontalArrangement = Arrangement.spacedBy(lpWToDpW(48)),
                    verticalAlignment = Alignment.CenterVertically
                ) {
                    sceneView.iconInfoContentsData.iconInfoList.forEachIndexed { index, iconInfo ->
                        item {
                            Box(
                                Modifier
                                    .lpSize(320, 414)
                                    .border(MiniCompose.debugBorder)
                                    .clickable { sceneView.onIconInfo(index) }) {
                                Column {
                                    MiniImage(
                                        resId = R.drawable.scene_home_accompany_icon,
                                        modifier = Modifier.size(lpWToDpW(320), lpWToDpW(320))
                                    )
                                    MiniText(
                                        text = iconInfo.name,
                                        color = Color.White,
                                        modifier = Modifier.size(lpWToDpW(320), lpWToDpW(94))
                                            .wrapContentSize()
                                    )
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}