package com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import com.clobot.minibasic.R
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.mode.GuideModeManager
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.MiniTextImageButton
import com.clobot.minibasic.data.task.YesOrNoPopupTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.data.task.mini.SystemCompose
import com.clobot.minibasic.data.task.mini.SystemPopupBg
import com.clobot.minibasic.data.task.mini.SystemPopupCompose
import com.clobot.minibasic.view.layer3_popup.PopupView

class AccompanyStartMovePopupTask(private val poi: String) : YesOrNoPopupTask(Result.NO) {
    override val popupView : PopupView
        get() {
            return PopupView.AccompanyStartMove(
                poi,
                countSec, { onYes() }, { onNo() })
        }
    override val timeoutSec = GuideModeManager.showStartMovePopupTimeoutSec
}

@Composable
fun AccompanyStartMovePopupScreen(popupView: PopupView.AccompanyStartMove) {
    SystemPopupBg() {
        MiniText(
            popupView.poi,
            Modifier.lp(648, 446, 456, 64),
            SystemCompose.highlightTextColor,
            lpToSp(SystemPopupCompose.mainTextFontSize),
            textAlign = TextAlign.Left,
        )
        MiniText(
            "이동을 시작합니다.",
            Modifier.lp(648, 518, 456, 64),
            SystemPopupCompose.mainTextColor,
            lpToSp(SystemPopupCompose.mainTextFontSize),
            textAlign = TextAlign.Left,
        )
        MiniTextImageButton(
            649,
            619,
            302,
            88,
            R.drawable.popup_system_no_btn,
            "아니오",
            SystemPopupCompose.noButtonTextColor,
            SystemPopupCompose.buttonTextFontSize,
            popupView.onNo,
        )
        MiniTextImageButton(
            970,
            619,
            302,
            88,
            R.drawable.popup_system_yes_btn,
            "네(${popupView.countSec})",
            SystemPopupCompose.yesButtonTextColor,
            SystemPopupCompose.buttonTextFontSize,
            popupView.onYes,
        )
    }
}