package com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany

import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.alpha
import androidx.compose.ui.graphics.Color
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.task.MiniBlackBg
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.MiniTextImageButton
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.data.task.lpWToDpW
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class AccompanyPlaceListSceneTask(private val page: Int) : SceneTask() {


    sealed class Result {
        class PlaceInfoScene(val index: Int, val page: Int): Result()
        class PlaceInfoPopup(val index: Int, val page: Int): Result()
        data object Back: Result()
    }

    val resultChannel = Channel<Result>()

    override fun onBegin() {
        super.onBegin()

        CaptionManager.naviCaptionPart.isShow = true

    }
    override fun onEnd() {
        super.onEnd()
        CaptionManager.naviCaptionPart.isShow = false
    }

    override val timeoutSec = 100

    private fun updateView() {
        setSceneView(
            SceneView.AccompanyPlaceList(
                page,
                ContentsManager.accompanyContents.accompanyContentsData?.placeList?.toList(),
                onPlace = { index, page->
                    onPlaceInfoItem(index, page)
                },
            )
        )
    }
    override suspend fun onRun(): Result {
        return coroutineScope {
            val navigationJobCaptionJob = launch {
                CaptionManager.naviCaptionPart.receive()
                resultChannel.send(Result.Back)
            }
            val countJob = launch {
                if (RobotManager.isPersonSf.value == null) {
                    runCountJob {
                        updateView()
                    }
                    resultChannel.send(Result.Back)
                }
            }
            val personCheckJob = launch {
                if (RobotManager.isPersonSf.value != null) {
                    var noPersonCountSec = 0
                    while (true) {
                        if (RobotManager.isPersonSf.value!!)
                            noPersonCountSec = 0
                        else
                            noPersonCountSec++
                        delay(1000)

                        if (noPersonCountSec > 5)
                            break
                    }
                    resultChannel.send(Result.Back)
                }
            }

            updateView()

            try {
                resultChannel.receive()
            } finally {
                countJob.cancel()
                personCheckJob.cancel()
                navigationJobCaptionJob.cancel()
            }
        }
    }
    private fun onPlaceInfoItem(index: Int, page: Int) {
        if (ContentsManager.accompanyContents.accompanyContentsData?.placeList?.get(index)?.page != null) {
            taskCoroutineScope?.launch {
                resultChannel.send(Result.PlaceInfoScene(index, page))
            }
        } else {
            taskCoroutineScope?.launch {
                resultChannel.send(Result.PlaceInfoPopup(index, page))
            }
        }
    }
}
@Composable
fun AccompanyPlaceListSceneScreen(sceneView: SceneView.AccompanyPlaceList) {
    MiniBlackBg {
        MiniText("로봇과 동행하실 장소를 선택하세요",
            Modifier
                .lp(394 - 40, 160, 1133 + 80, 100)
                .wrapContentSize(), Color.White, lpToSp(80)
        )
        if (sceneView.placeList != null) {

            val pageItemCount = 4

            val pageCount = ((sceneView.placeList.size - 1) / pageItemCount) + 1

            var page by remember {
                mutableIntStateOf(sceneView.page)
            }
            var index = page * pageItemCount
            repeat(4) { j ->
                repeat(3) { i ->
                    if (j * 4 + i <= pageItemCount && index < sceneView.placeList.size) {
                        val selIndex = index
                        MiniTextImageButton(256 + i * 480,
                            308 + j * 156,
                            466,
                            132,
                            R.drawable.scene_accompany_place_list_place_info_btn,
                            "${index + 1}: " + sceneView.placeList[index].name,
                            Color.White,
                            48,
                            onClick = {
                                sceneView.onPlace(selIndex, page)
                            })
                    }
                    index++
                }
            }
            if (page - 1 >= 0)
                MiniImage(
                    resId = R.drawable.scene_accompany_place_list_prev_btn,
                    modifier = Modifier
                        .lp(64, 524, 144, 144)
                        .clickable {
                            page--
                        }
                )
            else
                MiniImage(
                    resId = R.drawable.scene_accompany_place_list_prev_btn,
                    modifier = Modifier
                        .lp(64, 524, 144, 144)
                        .alpha(0.4f)
                )

            if (page + 1 < pageCount)
                MiniImage(resId = R.drawable.scene_accompany_place_list_next_btn , modifier = Modifier
                    .lp(1712, 524, 144, 144)
                    .clickable {
                        page++
                    })
            else
                MiniImage(resId = R.drawable.scene_accompany_place_list_next_btn , modifier = Modifier
                    .lp(1712, 524, 144, 144)
                    .alpha(0.4f))

            LazyRow(
                Modifier
                    .lp(890, 970, 140, 56)
                    .border(MiniCompose.debugBorder)
                , horizontalArrangement = Arrangement.SpaceEvenly, verticalAlignment = Alignment.CenterVertically) {
                    repeat(pageCount) {
                        item {
                            val resId = if (it == page) R.drawable.scene_accompany_place_list_cur_page_btn else R.drawable.scene_accompany_place_list_page_btn
                            MiniImage(resId, Modifier
                                .size(lpWToDpW(16), lpWToDpW(16))
                                .border(MiniCompose.debugBorder).clickable {
                                    page = it
                                })
                        }
                    }
                }
        }
    }
}
