package com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.task.MiniBlackBg
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.data.task.mini.SystemCompose
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class AccompanyPlaceInfoSceneTask(private val placeInfoItemIndex: Int) : SceneTask() {

    sealed class Result {
        class Guide(val index: Int): Result()
        data object Back: Result()
    }

    val resultChannel = Channel<Result>()

    override fun onBegin() {
        super.onBegin()

        CaptionManager.naviCaptionPart.isShow = true

    }
    override fun onEnd() {
        super.onEnd()
        CaptionManager.naviCaptionPart.isShow = false
    }

    override val timeoutSec = 100

    private fun updateView() {

        val placeInfoItem = ContentsManager.accompanyContents.accompanyContentsData?.placeList?.get(placeInfoItemIndex)
        if (placeInfoItem != null)
            setSceneView(
                SceneView.AccompanyPlaceInfo(
                    placeInfoItem.poi.ifEmpty { placeInfoItem.name },
                    placeInfoItem.page?.title ?: "",
                    placeInfoItem.page?.desc ?: "",
                    placeInfoItem.page?.image ?: ""
                )
            )
        else
            setSceneView(
                SceneView.AccompanyPlaceInfo( "",
                    "",
                    "",
                    ""
                )
            )
    }

    override suspend fun onRun(): Result {

        return coroutineScope {
            val navigationJobCaptionJob = launch {
                CaptionManager.naviCaptionPart.receive()
                resultChannel.send(Result.Back)
            }
            val countJob = launch {
                if (RobotManager.isPersonSf.value == null) {
                    runCountJob {
                        updateView()
                    }
                    resultChannel.send(Result.Back)
                }
            }
            val personCheckJob = launch {
                if (RobotManager.isPersonSf.value != null) {
                    var noPersonCountSec = 0
                    while (true) {
                        if (RobotManager.isPersonSf.value!!)
                            noPersonCountSec = 0
                        else
                            noPersonCountSec++
                        delay(1000)

                        if (noPersonCountSec > 5)
                            break
                    }
                    resultChannel.send(Result.Back)
                }
            }

            updateView()

            try {
                resultChannel.receive()
            } finally {
                countJob.cancel()
                personCheckJob.cancel()
                navigationJobCaptionJob.cancel()
            }
        }
    }

}

@Composable
fun AccompanyPlaceInfoSceneScreen(sceneView: SceneView.AccompanyPlaceInfo) {
    MiniBlackBg {
        MiniText(sceneView.poi,
            Modifier
                .lp(10, 160, MiniCompose.bg_width - 20, 100)
                .wrapContentSize(), SystemCompose.highlightTextColor, lpToSp(80)
        )
        MiniImage(R.drawable.scene_accompany_show_place_info_text, Modifier.lp(1150, 308, 708, 530))
        MiniText(sceneView.title, Modifier.lp(1198, 356, 319, 80), SystemCompose.textColor, lpToSp(64))
        MiniText(sceneView.desc, Modifier.lp(1198, 452, 612, 216), SystemCompose.textColor, lpToSp(36), textAlign = TextAlign.Left)
        //MiniImage(,
        MiniImage(R.drawable.scene_accompany_show_place_info_start_btn,
            Modifier
                .lp(702, 900, 516, 132)
                .clickable { })
    }
}
