package com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany

import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import com.clobot.minibasic.R
import com.clobot.minibasic.data.mode.GuideModeManager
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.MiniTextImageButton
import com.clobot.minibasic.data.task.NoticeSceneTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.data.task.mini.SystemCompose
import com.clobot.minibasic.view.layer1_scene.SceneView

class AccompanyCompleteSceneTask(private val poi: String) : NoticeSceneTask() {
    override val timeoutSec = GuideModeManager.completeSceneTimeoutSec
    override val ttsText = "${poi}에 도착하였습니다."

    override val sceneView: SceneView
        get() {
            return SceneView.AccompanyComplete(poi, countSec, { onOk() })
        }
}

@Composable
fun AccompanyCompleteSceneScreen(sceneView: SceneView.AccompanyComplete) {
    MiniImageBg(R.drawable.scene_accompany_complete_bg) {

        MiniText(
            buildAnnotatedString {
                withStyle(SpanStyle(SystemCompose.highlightTextColor)) {
                    append(sceneView.poi)
                }
                append("에\n 도착하였습니다.")
            },
            Modifier
                .lp(0, 157, MiniCompose.bg_width, 107)
                .wrapContentSize(),
            SystemCompose.textColor, lpToSp(SystemCompose.largeFontSize)
        )

        MiniTextImageButton(
            702,
            943,
            516,
            103,
            R.drawable.scene_accompany_complete_ok_btn,
            "확인(${sceneView.countSec})",
            SystemCompose.textColor,
            SystemCompose.largeButtonFontSize,
            sceneView.onOk,
        )
    }
}
