package com.clobot.minibasic.data.task.mini.loop.mode.guide

import com.clobot.minibasic.data.SetupManger
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.task.Task
import com.clobot.minibasic.data.task.YesOrNoPopupTask
import com.clobot.minibasic.data.task.mini.loop.mode.ShowChangeModeSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyCancelMovePopupTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyCompleteSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyPlaceInfoSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyPlaceListSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyStartMovePopupTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.icon_info.IconInfoListSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.icon_info.IconInfoSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.menu_info.MenuInfoListSceneTask
import com.clobot.minibasic.data.task.mini.loop.mode.guide.move.GuideMoveTask
import com.clobot.minibasic.data.task.mini.loop.move.MoveTask

class GuideTask : Task() {


    private suspend fun runAccompanyContents() {
        var page = 0
        showPlaceListLoop@ while (true) {
            when (val showPlaceListRes = AccompanyPlaceListSceneTask(page).run() as AccompanyPlaceListSceneTask.Result) {
                is AccompanyPlaceListSceneTask.Result.Back -> break
                is AccompanyPlaceListSceneTask.Result.PlaceInfoScene -> {
                    page = showPlaceListRes.page

                    val placeInfoItem = ContentsManager.accompanyContents.accompanyContentsData?.placeList?.get(showPlaceListRes.index)
                    val poi = placeInfoItem?.poi?.ifEmpty { placeInfoItem.name } ?: ""

                    when(AccompanyPlaceInfoSceneTask(showPlaceListRes.index).run() as AccompanyPlaceInfoSceneTask.Result) {
                        is AccompanyPlaceInfoSceneTask.Result.Guide -> {
                            if (poi.isNotEmpty()) {
                                while (true) {
                                    when (GuideMoveTask(poi).run() as GuideMoveTask.Result) {
                                        GuideMoveTask.Result.OK -> {
                                            AccompanyCompleteSceneTask(poi).run()
                                            break@showPlaceListLoop
                                        }

                                        GuideMoveTask.Result.CHANGE_DEST -> break
                                        GuideMoveTask.Result.ABORT -> {
                                            when (AccompanyCancelMovePopupTask(poi).run() as YesOrNoPopupTask.Result) {
                                                YesOrNoPopupTask.Result.YES -> break@showPlaceListLoop
                                                YesOrNoPopupTask.Result.NO -> {}
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        is AccompanyPlaceInfoSceneTask.Result.Back -> {
                        }
                    }
                }

                is AccompanyPlaceListSceneTask.Result.PlaceInfoPopup -> {
                    page = showPlaceListRes.page

                    val placeInfoItem = ContentsManager.accompanyContents.accompanyContentsData?.placeList?.get(showPlaceListRes.index)
                    val poi = placeInfoItem?.poi?.ifEmpty { placeInfoItem.name } ?: ""

                    if (poi.isNotEmpty()) {
                        when (AccompanyStartMovePopupTask(poi).run() as YesOrNoPopupTask.Result) {
                            YesOrNoPopupTask.Result.YES -> {
                                while (true) {
                                    when (GuideMoveTask(poi).run() as GuideMoveTask.Result) {
                                        GuideMoveTask.Result.OK -> {
                                            AccompanyCompleteSceneTask(poi).run()
                                            break@showPlaceListLoop
                                        }

                                        GuideMoveTask.Result.CHANGE_DEST -> break
                                        GuideMoveTask.Result.ABORT -> {
                                            when (AccompanyCancelMovePopupTask(poi).run() as YesOrNoPopupTask.Result) {
                                                YesOrNoPopupTask.Result.YES -> break@showPlaceListLoop
                                                YesOrNoPopupTask.Result.NO -> {}
                                            }
                                        }
                                    }
                                }
                            }

                            YesOrNoPopupTask.Result.NO -> {}
                        }
                    } else {

                    }

                }
            }
        }
    }

    private suspend fun runMenuInfoContents() {
        when (MenuInfoListSceneTask().run() as ContentsSceneTask.Result) {
            ContentsSceneTask.Result.BACK -> {}
            ContentsSceneTask.Result.HOME -> {}
        }
    }
    private suspend fun runIconInfoContents() {
        while (true) {
            when (val res = IconInfoListSceneTask().run() as IconInfoListSceneTask.Result) {
                is IconInfoListSceneTask.Result.IconInfo -> {
                    when (IconInfoSceneTask(res.index).run() as ContentsSceneTask.Result) {
                        ContentsSceneTask.Result.BACK -> {}
                        ContentsSceneTask.Result.HOME -> break
                    }
                }
                is IconInfoListSceneTask.Result.Home -> break
                is IconInfoListSceneTask.Result.Back -> break
            }
        }
    }


    override suspend fun onRun() {
        while (true) {
            MoveTask(SetupManger.Open.Move.initPosPoi).run()
            when (val homeRes = GuideHomeSceneTask().run() as GuideHomeSceneTask.Result) {
                is GuideHomeSceneTask.Result.Info -> {
                    when (homeRes.index) {
                        0 -> runAccompanyContents()
                        1 -> runMenuInfoContents()
                        2 -> runIconInfoContents()
                    }
                }
                is GuideHomeSceneTask.Result.ModeChange -> {
                    when (ShowChangeModeSceneTask(homeRes.mode).run() as ShowChangeModeSceneTask.Result) {
                        ShowChangeModeSceneTask.Result.OK -> {
                            ModeManager.setMode(homeRes.mode)
                            return
                        }
                        ShowChangeModeSceneTask.Result.SKIP -> {
                            ModeManager.setExtendTime()
                        }
                    }
                }
            }
        }
    }
}
