package com.clobot.minibasic.data.task.mini.loop.mode.guide

import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import com.clobot.minibasic.R
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpSize
import com.clobot.minibasic.data.task.lpWToDpW
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class GuideHomeSceneTask: SceneTask() {

    sealed class Result {
        class Info(val index: Int): Result()
        class ModeChange(val mode: ModeManager.Mode): Result()
    }

    private val resultChannel = Channel<Result>()

    override suspend fun onRun(): Result {
        return coroutineScope {
            val operationJob = launch {
                while(true) {
                    if (OperationManager.stateSf.value?.mode != ModeManager.Mode.GUIDE) {
                        if (!ModeManager.isExtend)
                            resultChannel.send(Result.ModeChange(OperationManager.stateSf.value?.mode!!))
                    }
                    delay(500)
                }
            }
            updateView()

            try {
                resultChannel.receive()
            } finally {
                operationJob.cancel()
            }
        }
    }

    private fun updateView() {
        setSceneView(
            SceneView.GuideHome(
                ContentsManager.accompanyContents.accompanyContentsData,
                {onInfo(0)},
                ContentsManager.menuInfoContents.menuInfoContentsData,
                {onInfo(1)},
                ContentsManager.iconInfoContents.iconInfoContentsData,
                {onInfo(2)},
            )
        )
    }

    private fun onInfo(index: Int) {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.Info(index))
        }
    }

    override fun onPause(isPause: Boolean) {
        if (!isPause) {
            ModeManager.resetExtendTime()
            updateView()
        }
    }
}

@Composable
fun GuideHomeSceneScreen(sceneView: SceneView.GuideHome) {
    MiniImageBg(R.drawable.scene_home_bg) {

        LazyRow(
            Modifier
                .lp(10, 395, MiniCompose.bg_width - 20, 414).wrapContentSize()
            , horizontalArrangement = Arrangement.spacedBy(lpWToDpW(48)) , verticalAlignment = Alignment.CenterVertically
            ) {

            if (sceneView.accompanyContentsData != null) {
                item {
                    Box(
                        Modifier
                            .lpSize(320, 414)
                            .clickable { sceneView.onAccompany() }) {
                        Column {
                            MiniImage(resId = R.drawable.scene_home_accompany_icon, modifier = Modifier.lpSize(320, 320))
                            MiniText(text = sceneView.accompanyContentsData.name, color = Color.White, modifier = Modifier.lpSize(320, 94).wrapContentSize())
                        }
                    }
                }
            }
            if (sceneView.menuInfoContentsData != null) {
                item {
                    Box(
                        Modifier
                            .lpSize(320, 414)
                            .clickable { sceneView.onMenuInfo() }) {
                        Column {
                            MiniImage(resId = R.drawable.scene_home_menu_info_icon, modifier = Modifier.lpSize(320, 320))
                            MiniText(text = sceneView.menuInfoContentsData.name, color = Color.White, modifier = Modifier.lpSize(320, 94).wrapContentSize())
                        }
                    }
                }
            }
            if (sceneView.iconInfoContentsData != null) {
                item {
                    Box(
                        Modifier
                            .lpSize(320, 414)
                            .clickable { sceneView.onIconInfo() }) {
                        Column {
                            MiniImage(resId = R.drawable.scene_home_icon_info_icon, modifier = Modifier.lpSize(320, 320))
                            MiniText(text = sceneView.iconInfoContentsData.name, color = Color.White, modifier = Modifier.lpSize(320, 94).wrapContentSize())
                        }
                    }
                }
            }
        }
    }
}
