package com.clobot.minibasic.data.task.mini.loop.mode.guide

import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.part.NaviCaptionPart
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

abstract class ContentsSceneTask : SceneTask() {

    enum class Result {
        BACK, HOME
    }

    val resultChannel = Channel<Result>()

    override fun onBegin() {
        super.onBegin()

        CaptionManager.naviCaptionPart.isShow = true

    }
    override fun onEnd() {
        super.onEnd()
        CaptionManager.naviCaptionPart.isShow = false
    }


    override val timeoutSec = 100

    abstract fun updateView()

    override suspend fun onRun() : Result {
        return coroutineScope {
            val navigationJobCaptionJob = launch {
                when (CaptionManager.naviCaptionPart.receive()) {
                    NaviCaptionPart.Result.BACK -> resultChannel.send(Result.BACK)
                    NaviCaptionPart.Result.HOME -> resultChannel.send(Result.HOME)
                }
            }
            val countJob = launch {
                if (RobotManager.isPersonSf.value == null) {
                    runCountJob {
                        updateView()
                    }
                    resultChannel.send(Result.HOME)
                }
            }
            val personCheckJob = launch {
                if (RobotManager.isPersonSf.value != null) {
                    var noPersonCountSec = 0
                    while (true) {
                        if (RobotManager.isPersonSf.value!!)
                            noPersonCountSec = 0
                        else
                            noPersonCountSec++
                        delay(1000)

                        if (noPersonCountSec > 5)
                            break
                    }
                    resultChannel.send(Result.HOME)
                }
            }

            updateView()

            try {
                resultChannel.receive()
            } finally {
                countJob.cancel()
                personCheckJob.cancel()
                navigationJobCaptionJob.cancel()
            }
        }
    }
}
