package com.clobot.minibasic.data.task.mini.loop.charge

import com.ainirobot.coreservice.client.Definition
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.task.Task

class ChargeTask: Task() {

    override suspend fun onRun(): Boolean {
        while (RobotManager.isChargingSf.value != true) {
            when (ChargeShowStartSceneTask().run() as ChargeShowStartSceneTask.Result) {
                ChargeShowStartSceneTask.Result.OK -> {}
                ChargeShowStartSceneTask.Result.ABORT -> return false
            }

            for (i in 0 until Int.MAX_VALUE) {
                val res = ChargeStartSceneTask(i).run() as ChargeStartSceneTask.Result
                when (res) {
                    is ChargeStartSceneTask.Result.Ok -> return true
                    is ChargeStartSceneTask.Result.StartChargeResult -> {
                        if (res.startChargeResult is RobotManager.StartChargeResult.OnResult &&
                            res.startChargeResult.status == Definition.RESULT_OK)
                            return true
                    }
                    is ChargeStartSceneTask.Result.UserAbort -> {}
                }
                when (ChargeShowFailSceneTask(i, res).run() as ChargeShowFailSceneTask.Result) {
                    ChargeShowFailSceneTask.Result.RETRY -> {}
                    ChargeShowFailSceneTask.Result.STAY -> {
                        when (ChargeStayFailedSceneTask().run() as ChargeStayFailedSceneTask.Result) {
                            ChargeStayFailedSceneTask.Result.RESTART -> break
                            ChargeStayFailedSceneTask.Result.ABORT -> return false
                        }
                    }
                    ChargeShowFailSceneTask.Result.ABORT ->
                        return false
                }
            }
        }
        return true
    }

}


