package com.clobot.minibasic.data.task.mini.loop.charge

import androidx.compose.runtime.Composable
import com.clobot.minibasic.R
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.mini.SystemButton1
import com.clobot.minibasic.data.task.mini.SystemButton2
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.data.task.mini.SystemSubText
import com.clobot.minibasic.data.task.mini.loop.mode.rest.RestOperationStateView
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch

class ChargeStayFailedSceneTask : SceneTask() {

    enum class Result {
        RESTART, ABORT,
    }

    private val resultChannel = Channel<Result>()

    private fun updateView() {
        setSceneView(SceneView.ChargeStayFailed({ onRestart() }, { onAbort() }, OperationManager.stateSf.value!!))
    }
    override suspend fun onRun(): Result {
        return coroutineScope {
            updateView()
            val operationJob = launch {
                OperationManager.stateSf.collect() {
                    updateView()
                }
            }
            try {
                resultChannel.receive()
            } finally {
                operationJob.cancel()
            }
        }
    }

    private fun onRestart() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.RESTART)
        }
    }
    private fun onAbort() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.ABORT)
        }
    }

}
@Composable
fun ChargeStayFailedSceneScreen(sceneView: SceneView.ChargeStayFailed) {
    MiniImageBg(R.drawable.scene_charge_show_fail_bg) {
        SystemMainText("충전에 실패하여 대기합니다.")

        SystemButton1(
            onClick = sceneView.onRestart,
            text = "재시작"
        )
        SystemButton2(
            onClick = sceneView.onAbort,
            text = "취소"
        )

        RestOperationStateView(sceneView.operationState)

        SystemSubText("실패가 여러번 반복될 경우 관리자에게 문의 바랍니다.")
    }
}
