package com.clobot.minibasic.data.task.mini.loop

import android.content.Context
import com.clobot.minibasic.data.ClockManager
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.contents.ContentsManager
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.Task
import com.clobot.minibasic.data.task.mini.loop.mode.guide.GuideTask
import com.clobot.minibasic.data.task.mini.loop.mode.promote.PromoteTask
import com.clobot.minibasic.data.task.mini.loop.mode.rest.RestTask
import kotlinx.coroutines.delay


class LoopTask(private val context: Context): Task() {

    fun init() {
        OperationManager.init(RobotManager.batteryLevelSf.value!!, ClockManager.dateTimeSf.value)

        ContentsManager.load()

        ModeManager.setMode(OperationManager.stateSf.value!!.mode)
    }
    override suspend fun onRun() {

        init()

        while (true) {

            when (ModeManager.modeSf.value) {
                ModeManager.Mode.REST -> RestTask().run()
                ModeManager.Mode.GUIDE -> GuideTask().run()
                ModeManager.Mode.PROMOTE -> PromoteTask().run()
            }
        }
    }
}