package com.clobot.minibasic.data.task.mini.init

import androidx.compose.runtime.Composable
import com.clobot.minibasic.R
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.mini.SystemButton1
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.data.task.mini.SystemSubText
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.launch

class InitStayFailedSceneTask : SceneTask() {

    private val resultChannel = Channel<Unit>()
    override suspend fun onRun() {
        setSceneView(SceneView.InitStayFailed({ onRestart() }))
        resultChannel.receive()
    }

    private fun onRestart() {
        taskCoroutineScope?.launch {
            resultChannel.send(Unit)
        }
    }
}

@Composable
fun InitStayFailedSceneScreen(sceneView: SceneView.InitStayFailed) {
    MiniImageBg(R.drawable.scene_init_show_fail_bg) {
        SystemMainText(text = "로봇을 초기화 하는데 실패하여 대기합니다.")

        SystemButton1(
            onClick = sceneView.onRestart,
            text = "재시작"
        )
        SystemSubText("실패가 여러번 반복될 경우 관리자에게 문의 바랍니다.")
    }
}
