package com.clobot.minibasic.data.task.mini.init

import android.content.Context
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import com.clobot.minibasic.BuildConfig
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.mini.SystemCompose
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.data.task.mini.SystemProgressBar
import com.clobot.minibasic.data.task.mini.SystemProgressText
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class InitStartSceneTask(private val context: Context, private val tryCount: Int): SceneTask() {
    enum class Result {
        OK, FAIL
    }

    override suspend fun onRun(): Result {
        return coroutineScope {
            val countJob = launch {
                runCountJob() {
                    setSceneView(SceneView.InitStart(BuildConfig.VERSION_NAME, elapseSec))
                }
            }
            try {
                delay(1000)
                if (RobotManager.init(context, BuildConfig.isRobot, BuildConfig.isPersonNullTest))
                    Result.OK
                else
                    Result.FAIL
            } finally {
                countJob.cancel()
            }
        }
    }
}

@Composable
fun InitStartSceneScreen(sceneView: SceneView.InitStart) {
    MiniImageBg(R.drawable.scene_init_start_bg) {
        SystemMainText(text = "프로그램(v${sceneView.version})을 시작 하는 중 입니다.\n로봇 초기화 중...")
        SystemProgressBar() {
            CircularProgressIndicator(modifier = Modifier.fillMaxSize(),
                color = Color.White,
            )
        }
        if (sceneView.elapsedSec >= 3)
            SystemProgressText(sceneView.elapsedSec)
    }
}