package com.clobot.minibasic.data.task.mini.init

import androidx.compose.runtime.Composable
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import com.clobot.minibasic.R
import com.clobot.minibasic.data.SetupManger
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.SceneTask
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.data.task.mini.SystemButton1
import com.clobot.minibasic.data.task.mini.SystemButton2
import com.clobot.minibasic.data.task.mini.SystemMainText
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch

class InitShowFailSceneTask(private val tryCount: Int) : SceneTask() {

    enum class Result {
        RETRY, STAY
    }

    private val resultChannel = Channel<Result>()

    override val timeoutSec: Int = SetupManger.Init.initShowFailSceneTimeoutSec
    override suspend fun onRun(): Result {
        return coroutineScope {
            val countJob = launch {
                runCountJob () {
                    setSceneView(SceneView.InitShowFail(tryCount, SetupManger.Init.initTryMaxCount, countSec, {onRetry()}, {onStay()}))
                }
                resultChannel.send(if (tryCount < SetupManger.Init.initTryMaxCount - 1) Result.RETRY else Result.STAY)
            }
            try {
                resultChannel.receive()
            } finally {
                countJob.cancel()
            }
        }
    }
    private fun onRetry() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.RETRY)
        }
    }
    private fun onStay() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.STAY)
        }
    }
}
@Composable
fun InitShowFailSceneScreen(sceneView: SceneView.InitShowFail) {
    MiniImageBg(R.drawable.scene_init_show_fail_bg) {
        SystemMainText(text = buildAnnotatedString {
            append("로봇을 초기화 하는데 실패 하였습니다. ")
            withStyle(
                SpanStyle(fontSize = lpToSp(40))
            ) {
                append("(${sceneView.tryCount + 1}/${sceneView.tryCountMax})")
            }
        })


        SystemButton1(
            onClick = sceneView.onRetry, text =
            if (sceneView.tryCount < sceneView.tryCountMax - 1)
                "재시도 (${sceneView.countSec})"
            else
                "재시도"
        )
        SystemButton2(
            onClick = sceneView.onStay, text =
            if (sceneView.tryCount >= sceneView.tryCountMax - 1)
                "대기 (${sceneView.countSec})"
            else
                "대기"
        )
    }
}