package com.clobot.minibasic.data.task.mini

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.AnnotatedString
import androidx.compose.ui.text.style.TextAlign
import com.clobot.minibasic.R
import com.clobot.minibasic.data.task.MiniFitText
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniTextImageButton
import com.clobot.minibasic.data.task.lp


class SystemPopupCompose {
    companion object {
        val mainTextColor = Color(0xFF1B1C1E)
        const val mainTextFontSize = 48
        val subTextColor = Color(0xFF1B1C1E)
        const val subTextFontSize = 41
        const val subTextHighlightFontSize = 60
        val textHighlightColor = Color(0xFF5856D6)

        val okButtonTextColor = Color.White
        val yesButtonTextColor = Color.White
        val noButtonTextColor = mainTextColor
        const val buttonTextFontSize = 32
    }
}

@Composable
fun SystemPopupBg(contents: @Composable () -> Unit) {
    Box(
        modifier = Modifier
            .fillMaxSize()
            .background(Color(0.0f, 0.0f, 0.0f, 0.5f))
    ) {
        MiniImage(R.drawable.popup_system_bg, Modifier.lp(600, 422, 720, 316))
        contents()
    }
}

/*
@Composable
fun SystemPopupMainText(text: AnnotatedString) {
    MiniFitText(
        493, 354, 938, 65,
        text,
        SystemPopupCompose.mainTextColor,
        SystemPopupCompose.mainTextFontSize,
        textAlign = TextAlign.Left,
        extraW = 0,
        alignment = Alignment.CenterStart,
    )
}

@Composable
fun SystemPopupMainText(text: String) {
    SystemPopupMainText(AnnotatedString(text))
}


@Composable
fun SystemPopupSubText(text: AnnotatedString) {
    MiniFitText(
        //493, 516, 938, 36,
        493, 498, 938, 52,
        text,
        SystemPopupCompose.subTextColor,
        SystemPopupCompose.subTextFontSize,
        textAlign = TextAlign.Left,
        extraW = 0,
        alignment = Alignment.CenterStart,
        extraH = 30,
    )
}
@Composable
fun SystemPopupSubText(text: String) {
    SystemPopupSubText(AnnotatedString(text))
}

@Composable
fun SystemPopupConfirmButton(text: String, onClick: () -> Unit) {
    MiniTextImageButton(
        1182,
        645,
        246,
        113,
        R.drawable.popup_system_ok_btn,
        text,
        SystemPopupCompose.okButtonTextColor,
        SystemPopupCompose.buttonTextFontSize,
        onClick
    )
}
*/
