package com.clobot.minibasic.data.task.mini

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.AnnotatedString
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.R
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpHToDpH
import com.clobot.minibasic.data.task.lpToSp

@Composable
fun SystemMainText(text: AnnotatedString, color: Color = Color.White) {
    MiniText(
        text,
        Modifier
            .lp(10, 280, 1900, 260)
            .wrapContentSize(),
        color,
        lpToSp(80),
    )
}

@Composable
fun SystemMainText(text: String, color: Color = Color.White) {
    SystemMainText(AnnotatedString(text), color)
}

@Composable
fun SystemSubText(text: AnnotatedString, color: Color = Color.Red) {
    MiniText(
        text,
        Modifier
            .lp(10, 977, 1900, 100)
            .wrapContentSize(),
        color,
        lpToSp(40),
    )
}

@Composable
fun SystemSubText(text: String, color: Color = Color.Red) {
    SystemSubText(AnnotatedString(text), color)
}


@Composable
fun SystemProgressBar(contents: @Composable () -> Unit) {
    Box(Modifier.lp(MiniCompose.bg_center_x - 80, 630 - 20, 80 * 2, 80 * 2)) {
        Box(
            modifier = Modifier
                .fillMaxSize()
                .background(
                    Color(0f, 0f, 0f, 0.5f), shape = RoundedCornerShape(
                        lpHToDpH(30)
                    )
                )
        )
    }
    Box(Modifier.lp(MiniCompose.bg_center_x - 60, 630, 60 * 2, 60 * 2)) {
        contents()
    }
}

@Composable
fun SystemProgressText(timeSec: Int) {
    Box(Modifier.lp(0, 630, MiniCompose.bg_width, 60 * 2)) {
        val text = if (timeSec >= 60) String.format("%d:%02d", timeSec / 60, timeSec % 60) else timeSec.toString()
        MiniText(
            text = text,
            modifier = Modifier
                .fillMaxSize()
                .wrapContentSize(),
                fontSize = lpToSp(40),
            color = Color.White,
        )
    }
}


@Composable
fun SystemButton(x: Int, y: Int, w: Int, h: Int, text: String, onClick: () -> Unit) {
    Box(
        modifier = Modifier.lp(x, y, w, h)
            .background(Color(0f, 0f, 0f, alpha = 0.5f))
            .border(BorderStroke(2.dp, Color.White), RoundedCornerShape(5.dp))
            .clickable {
                onClick()
            },
        contentAlignment = Alignment.Center,
    ) {
        MiniText(
            text,
            color = Color.White,
            fontSize = lpToSp(30),
        )
    }
}

@Composable
fun SystemButton1(text: String, onClick: () -> Unit) {
    SystemButton(MiniCompose.bg_center_x - 200, 630, 200 * 2, 100, text, onClick)
}

@Composable
fun SystemButton2(text: String, onClick: () -> Unit) {
    SystemButton(MiniCompose.bg_center_x - 200, 770, 200 * 2, 100, text, onClick)
}
@Composable
fun SystemButton3(text: String, onClick: () -> Unit) {
    SystemButton(MiniCompose.bg_center_x - 200, 910, 200 * 2, 100, text, onClick)
}


class SystemCompose {
    companion object {
        val textColor = Color.White
        val highlightTextColor = Color(0xFFF2C94C)

        const val largeButtonFontSize = 48
        const val largeFontSize = 80
    }
}
