package com.clobot.minibasic.data.task

import com.clobot.minibasic.data.RobotManager
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

abstract class Task {
    suspend fun run(): Any {
        TaskManager.currentTask = this
        onBegin()
        val res = onRun()
        onEnd()
        return res
    }

    protected abstract suspend fun onRun(): Any

    protected val taskCoroutineScope: CoroutineScope?
        get() {
            return TaskManager.taskCoroutineScope
        }
    var isPause = TaskManager.isPause
        set (value) {
            field = value
            onPause(value)
        }

    protected open fun onBegin() {}
    protected open fun onEnd() {}
    protected open fun onPause(isPause: Boolean) {}



    var elapseSec = 0
        private set

    fun resetElapseSec() {
        elapseSec = 0
    }
    val countSec: Int
        get() {
            return timeoutSec - elapseSec
        }


    open val timeoutSec = Int.MAX_VALUE

    suspend fun runCountJob(onCounter: ()->Unit) {
        while (elapseSec <= timeoutSec) {
            onCounter()
            delay(1000)
            if (!isPause)
                elapseSec++
        }
    }
}

object TaskManager {
    lateinit var currentTask: Task
    var taskCoroutineScope: CoroutineScope? = null

    enum class Pause {
        User, Activity, Emergency
    }

    private var isPauseArr = BooleanArray(Pause.entries.size) {
        false
    }

    val isPause: Boolean
        get() {
            return isPauseArr.any {
                it
            }
        }

    fun pause(pause: Pause, value: Boolean) {
        val prevPause = isPause
        isPauseArr[pause.ordinal] = value
        if (prevPause != isPause)
            currentTask.isPause = isPause
    }


    init {
        MainScope().launch() {
            RobotManager.isEmergencySf.collect() {
                if (it == true) {
                    pause(Pause.Emergency, it)
                }
                else if (it == false) {
                    pause(Pause.Emergency, it)
                }
            }
        }
    }
}
