package com.clobot.minibasic.data.task

import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.SetupManger
import com.clobot.minibasic.view.layer1_scene.SceneView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch


abstract class SceneTask() : Task() {
    protected fun setSceneView(sceneView: SceneView) {
        SceneManager.setSceneView(sceneView)
    }
}

abstract class NoticeSceneTask: SceneTask() {

    abstract val sceneView: SceneView

    private var resultChannel = Channel<Unit>()

    open val ttsText: String = ""
    override suspend fun onRun() {
        return coroutineScope {
            val countJob = launch {
                runCountJob() {
                    setSceneView(sceneView)
                }
                resultChannel.send(Unit)
            }
            val ttsJob = launch {
                if (ttsText.isNotEmpty())
                    RobotManager.playText(ttsText, SetupManger.Robot.playTextMediumVolume)
            }

            try {
                resultChannel.receive()
            } finally {
                ttsJob.cancel()
                countJob.cancel()
            }
        }
    }

    protected fun onOk() {
        taskCoroutineScope?.launch {
            resultChannel.send(Unit)
        }
    }
}
