package com.clobot.minibasic.data.task

import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.clobot.minibasic.data.task.mini.init.InitShowFailSceneScreen
import com.clobot.minibasic.data.task.mini.init.InitStartSceneScreen
import com.clobot.minibasic.view.layer1_scene.SceneView
import com.clobot.minibasic.data.task.mini.init.InitStayFailedSceneScreen
import com.clobot.minibasic.data.task.mini.loop.charge.ChargeShowFailSceneScreen
import com.clobot.minibasic.data.task.mini.loop.charge.ChargeShowStartSceneScreen
import com.clobot.minibasic.data.task.mini.loop.charge.ChargeStartSceneScreen
import com.clobot.minibasic.data.task.mini.loop.charge.ChargeStayFailedSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.ShowChangeModeSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.GuideHomeSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyCompleteSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyPlaceInfoSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyPlaceListSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.icon_info.IconInfoListSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.icon_info.IconInfoSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.menu_info.MenuInfoListSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.move.GuideMoveNavigationShowFailSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.promote.PromotePausedSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.promote.PromoteRunningSceneScreen
import com.clobot.minibasic.data.task.mini.loop.mode.rest.RestSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveLeaveShowFailSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveLeaveShowStartSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveLeaveStartSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveLeaveStayFailedSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveNavigationShowFailSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveNavigationShowStartSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveNavigationStartSceneScreen
import com.clobot.minibasic.data.task.mini.loop.move.MoveNavigationStayFailedSceneScreen
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update

object SceneManager {
    private val sceneViewMsf = MutableStateFlow<SceneView?>(null)
    val sceneViewSf = sceneViewMsf.asStateFlow()
    fun setSceneView(sceneView: SceneView?) {
        sceneViewMsf.update {
            sceneView
        }
    }
}

@Composable
fun BaseSceneScreen(contents: @Composable () -> Unit) {
    Surface(
        modifier = Modifier.fillMaxSize(),
    ) {
        contents()
    }
}
@Composable
fun SceneScreen(sceneView: SceneView?) {
    if (sceneView == null)
        return
    when (sceneView) {
        is SceneView.InitStart -> InitStartSceneScreen(sceneView)
        is SceneView.InitShowFail ->  InitShowFailSceneScreen(sceneView)
        is SceneView.InitStayFailed -> InitStayFailedSceneScreen(sceneView)

        /*
        is SceneView.OpenShowClose -> OpenShowCloseSceneScreen(sceneView)
        */

        is SceneView.Rest -> RestSceneScreen(sceneView)

        is SceneView.ChargeShowStart -> ChargeShowStartSceneScreen(sceneView)
        is SceneView.ChargeStart -> ChargeStartSceneScreen(sceneView)
        is SceneView.ChargeShowFail -> ChargeShowFailSceneScreen(sceneView)
        is SceneView.ChargeStayFailed -> ChargeStayFailedSceneScreen(sceneView)

        is SceneView.GuideHome -> GuideHomeSceneScreen(sceneView)
        is SceneView.GuideMoveNavigationShowFail -> GuideMoveNavigationShowFailSceneScreen(sceneView)
        is SceneView.AccompanyPlaceList -> AccompanyPlaceListSceneScreen(sceneView)
        is SceneView.AccompanyPlaceInfo -> AccompanyPlaceInfoSceneScreen(sceneView)
        is SceneView.AccompanyComplete -> AccompanyCompleteSceneScreen(sceneView)

        is SceneView.MenuInfoList -> MenuInfoListSceneScreen(sceneView)

        is SceneView.IconInfoList -> IconInfoListSceneScreen(sceneView)
        is SceneView.IconInfo -> IconInfoSceneScreen(sceneView)

        is SceneView.MoveLeaveShowStart -> MoveLeaveShowStartSceneScreen(sceneView)
        is SceneView.MoveLeaveStart -> MoveLeaveStartSceneScreen(sceneView)
        is SceneView.MoveLeaveShowFail -> MoveLeaveShowFailSceneScreen(sceneView)
        is SceneView.MoveLeaveStayFailed -> MoveLeaveStayFailedSceneScreen(sceneView)

        is SceneView.MoveNavigationShowStart -> MoveNavigationShowStartSceneScreen(sceneView)
        is SceneView.MoveNavigationStart -> MoveNavigationStartSceneScreen(sceneView)
        is SceneView.MoveNavigationShowFail -> MoveNavigationShowFailSceneScreen(sceneView)
        is SceneView.MoveNavigationStayFailed -> MoveNavigationStayFailedSceneScreen(sceneView)

        is SceneView.ShowChangeMode -> ShowChangeModeSceneScreen(sceneView)

        /*
        is SceneView.GuideCallByNoConfirm -> GuideCallByNoConfirmSceneScreen(sceneView)
        is SceneView.GuideShowFail -> GuideShowFailSceneScreen(sceneView)
        is SceneView.GuideShowComplete -> GuideShowCompleteSceneScreen(sceneView)

        is SceneView.GuideCallByConfirm -> {}
        */

        is SceneView.PromoteRunning -> PromoteRunningSceneScreen(sceneView)
        is SceneView.PromotePaused -> PromotePausedSceneScreen(sceneView)


        //is SceneView.PromoteShowChangeMode -> PromoteShowChangeModeSceneScreen(sceneView)
    }
}

