package com.clobot.minibasic.data.task

import com.clobot.minibasic.data.popup.PopupManager
import com.clobot.minibasic.view.layer3_popup.PopupView
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.launch

abstract class PopupTask() : Task() {
    protected fun setPopupView(popupView: PopupView) {
        PopupManager.setPopupView(popupView)
        PopupManager.setIsShow(true)
    }
    override fun onEnd() {
        PopupManager.setIsShow(false)
    }
}

abstract class NoticePopupTask: PopupTask() {

    abstract val popupView: PopupView

    private var resultChannel = Channel<Unit>()
    override suspend fun onRun() {
        return coroutineScope {
            val countJob = launch {
                runCountJob() {
                    setPopupView(popupView)
                }
                resultChannel.send(Unit)
            }
            try {
                resultChannel.receive()
            } finally {
                countJob.cancel()
            }
        }
    }

    protected fun onOk() {
        taskCoroutineScope?.launch {
            resultChannel.send(Unit)
        }
    }
}

abstract class YesOrNoPopupTask(private val defaultResult:Result): PopupTask() {


    abstract val popupView: PopupView

    enum class Result {
        YES, NO,
    }

    private var resultChannel = Channel<Result>()

    override suspend fun onRun() : Result {
        return coroutineScope {
            val countJob = launch {
                runCountJob {
                    setPopupView(popupView)
                }
                resultChannel.send(defaultResult)
            }
            try {
                resultChannel.receive()
            } finally {
                countJob.cancel()
            }
        }
    }
    fun onYes() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.YES)
        }
    }
    fun onNo() {
        taskCoroutineScope?.launch {
            resultChannel.send(Result.NO)
        }
    }
}
