package com.clobot.minibasic.data.popup

import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyCancelMovePopupScreen
import com.clobot.minibasic.data.task.mini.loop.mode.guide.accompany.AccompanyStartMovePopupScreen
import com.clobot.minibasic.view.layer3_popup.PopupView
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update

object PopupManager {

    private val isShowMsf = MutableStateFlow(false)
    val isShowSf = isShowMsf.asStateFlow()
    fun setIsShow(isShow: Boolean) {
        isShowMsf.update {
            isShow
        }
    }

    private val popupViewMsf = MutableStateFlow<PopupView?>(null)
    val popupViewSf = popupViewMsf.asStateFlow()
    fun setPopupView(popupView: PopupView?) {
        popupViewMsf.update {
            popupView
        }
    }
}

@Composable
fun BasePopupScreen(contents: @Composable () -> Unit ) {
    Surface(modifier = Modifier.fillMaxSize(), color = Color.Transparent) {
        contents()
    }
}
@Composable
fun PopupScreen(popupView: PopupView?) {
    if (popupView != null) {
        when (popupView) {
            is PopupView.AccompanyStartMove -> AccompanyStartMovePopupScreen(popupView)
            is PopupView.AccompanyCancelMove -> AccompanyCancelMovePopupScreen(popupView)
        }
    }
}
