package com.clobot.minibasic.data.operation

import com.clobot.minibasic.data.ProfileManager
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.mode.ModeManager
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.launch

class SystemChecker {

    companion object {
        private const val CLASS_NAME = "SystemChecker::"

        private const val LOW_BATTERY_LEVEL_RANGE_FIRST_KEY = CLASS_NAME + "lowBatteryLevelRangeFirst"
        private const val LOW_BATTERY_LEVEL_RANGE_LAST_KEY = CLASS_NAME + "lowBatteryLevelRangeLast"
    }

    var lowBatteryLevelRange =
        ProfileManager.getPutInt(LOW_BATTERY_LEVEL_RANGE_FIRST_KEY,30)..ProfileManager.getPutInt(
            LOW_BATTERY_LEVEL_RANGE_LAST_KEY, 50)
        set (value) {
            ProfileManager.putInt(LOW_BATTERY_LEVEL_RANGE_FIRST_KEY, value.first)
            ProfileManager.putInt(LOW_BATTERY_LEVEL_RANGE_LAST_KEY, value.last)
            field = value
            update()
        }


    private var batteryLevel = 100
        set (value) {
            field = value
            update()
        }
    private var isRest = true
        set (value) {
            field = value
            update()
        }

    sealed class State(val isRest: Boolean) {
        class LowBattery(isRest: Boolean, val lowBatteryLevelRange: IntRange): State(isRest)
    }

    private fun check(): State {

        return State.LowBattery(
            if (!isRest)
                batteryLevel < lowBatteryLevelRange.first
            else
                batteryLevel < lowBatteryLevelRange.last,
            lowBatteryLevelRange
        )
    }

    private val stateMsf = MutableStateFlow(check())
    val stateSf = stateMsf.asStateFlow()

    private fun update() {
        stateMsf.update {
            check()
        }
    }

    fun init(initBatteryLevel: Int, initRest: Boolean) {

        batteryLevel = initBatteryLevel
        isRest = initRest

        update()

        MainScope().launch {
            RobotManager.batteryLevelSf.collect {
                if (it != null) {
                    batteryLevel = it
                }
            }
        }
        MainScope().launch {
            ModeManager.modeSf.collect {
                isRest = it == ModeManager.Mode.REST
            }
        }
    }
}
