package com.clobot.minibasic.data.operation

import com.clobot.minibasic.data.mode.ModeManager
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.launch
import java.time.LocalDateTime

object OperationManager {

    val systemChecker = SystemChecker()
    val scheduleChecker = ScheduleChecker()

    class State(val mode: ModeManager.Mode, val systemState: SystemChecker.State, val scheduleState: ScheduleChecker.State)


    private val stateMsf: MutableStateFlow<State?> = MutableStateFlow(null)
    val stateSf = stateMsf.asStateFlow()

    private fun check(): State {
        return if (systemChecker.stateSf.value.isRest)
            State(ModeManager.Mode.REST, systemChecker.stateSf.value, scheduleChecker.stateSf.value)
        else
            State(scheduleChecker.stateSf.value.mode, systemChecker.stateSf.value, scheduleChecker.stateSf.value)
    }
    private fun update() {
        stateMsf.update {
            check()
        }
    }

    fun init(batteryLevel: Int, localDateTime: LocalDateTime) {

        scheduleChecker.init(localDateTime)
        systemChecker.init(batteryLevel, scheduleChecker.stateSf.value.mode == ModeManager.Mode.REST)

        update()

        MainScope().launch {
            systemChecker.stateSf.collect {
                update()
            }
        }
        MainScope().launch {
            scheduleChecker.stateSf.collect {
                update()
            }
        }
    }
}
