package com.clobot.minibasic.data.mode

import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import java.time.LocalDateTime

object ModeManager {
    enum class Mode {
        REST, GUIDE, PROMOTE
    }

    private val modeMsf: MutableStateFlow<Mode> = MutableStateFlow(Mode.REST)
    val modeSf = modeMsf.asStateFlow()
    fun setMode(mode: Mode) {
        modeMsf.update {
            mode
        }
    }

    fun getModeName(mode: Mode): String {
        return when (mode) {
            Mode.REST -> "휴식 모드"
            Mode.GUIDE -> "안내 모드"
            Mode.PROMOTE -> "홍보 모드"
        }
    }

    private var extendTime: LocalDateTime? = null

    private const val operationExtendTimeSec = 60L
    val isExtend: Boolean
        get() {
            if(extendTime == null)
                return false
            else {
                val t = LocalDateTime.now()
                return t < extendTime!!.plusSeconds(operationExtendTimeSec)
            }
        }
    fun setExtendTime() {
        extendTime = LocalDateTime.now()
    }
    fun resetExtendTime() {
        extendTime = null
    }

}