package com.clobot.minibasic.data.devel.tab

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.ainirobot.coreservice.client.RobotApi
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.devel.DevelTab
import com.clobot.minibasic.view.layer7_devel.DevelTabView
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

class RobotDevelTab(develManager: DevelManager) : DevelTab(develManager) {
    override val name: String
        get() = "robot"
    override val develTabView: DevelTabView
        get() = DevelTabView.Robot(
            logList.toTypedArray(),
            RobotApi.getInstance().isApiConnectedService,
            RobotApi.getInstance().isActive,
            RobotManager.isEmergencySf.value,
            RobotManager.isChargingSf.value,
            RobotManager.batteryLevelSf.value,
            RobotManager.isPersonSf.value,
        )

    init {
        MainScope().launch {
            RobotManager.isEmergencySf.collect() {
                DevelManager.updateDevelTabView()
            }
        }
        MainScope().launch {
            RobotManager.isChargingSf.collect() {
                DevelManager.updateDevelTabView()
            }
        }
        MainScope().launch {
            RobotManager.batteryLevelSf.collect() {
                DevelManager.updateDevelTabView()
            }
        }
        MainScope().launch {
            RobotManager.isPersonSf.collect() {
                DevelManager.updateDevelTabView()
            }
        }
    }

}

@Composable
fun RobotDevelTabScreen(robotDevelTabView: DevelTabView.Robot) {
    Column() {
        LazyColumn() {
            item {
                LazyRow(horizontalArrangement = Arrangement.spacedBy(10.dp)) {
                    item {
                        Text("isConnectedService: ${robotDevelTabView.isConnectedService}")
                    }
                    item {
                        Text("isActive: ${robotDevelTabView.isActive}")
                    }
                }
            }
            item {
                LazyRow(horizontalArrangement = Arrangement.spacedBy(10.dp)) {
                    item {
                        Text("isEmergency: ${robotDevelTabView.isEmergency}")
                    }
                    item {
                        Text("isCharging: ${robotDevelTabView.isCharging}")
                    }
                    item {
                        Text("batteryLevel: ${robotDevelTabView.batteryLevel}")
                    }
                    item {
                        Text("isPerson: ${robotDevelTabView.isPerson}")
                    }
                }
            }
        }
        LazyColumn(modifier = Modifier.fillMaxSize().padding(10.dp).border(
            BorderStroke(
                width = 0.dp,
                color = Color.Red)
        )) {
            for (msg in robotDevelTabView.logArr.reversed()) {
                item {
                    Text(msg, fontSize = 8.sp)
                }
            }
        }
    }
}

