package com.clobot.minibasic.data.devel.tab

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.material3.Switch
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.devel.DevelTab
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.view.layer7_devel.DevelTabView

class GeneralDevelTab(develManager: DevelManager) : DevelTab(develManager) {
    override val name: String
        get() = "general"
    override val develTabView: DevelTabView
        get() = DevelTabView.General(logList.toTypedArray(), MiniCompose.isDebugBorder, onIsDebugBorder = {onIsDebugBorder(it)})

    private fun onIsDebugBorder(enable: Boolean) {
        MiniCompose.isDebugBorder = enable
        updateDevelTabView()
    }
}

@Composable
fun GeneralDevelTabScreen(develTabView: DevelTabView.General) {
    Column() {
        LazyColumn() {
            item {
                LazyRow(horizontalArrangement = Arrangement.spacedBy(10.dp), verticalAlignment = Alignment.CenterVertically) {
                    item {
                        Text("isDebugBorder(앱 재시작 시 적용): ")
                    }
                    item {
                        Switch(checked = develTabView.isDebugBorder, onCheckedChange = develTabView.onIsDebugBorder)
                    }
                }
            }
        }
        LazyColumn(modifier = Modifier.fillMaxSize().padding(10.dp).border(
            BorderStroke(
                width = 0.dp,
                color = Color.Red)
        )) {
            for (msg in develTabView.logArr.reversed()) {
                item {
                    Text(msg, fontSize = 8.sp)
                }
            }
        }
    }
}
