package com.clobot.minibasic.data.devel

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.material3.Button
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.data.devel.tab.GeneralDevelTab
import com.clobot.minibasic.data.devel.tab.GeneralDevelTabScreen
import com.clobot.minibasic.data.devel.tab.RobotDevelTab
import com.clobot.minibasic.data.devel.tab.RobotDevelTabScreen
import com.clobot.minibasic.view.layer7_devel.DevelTabListView
import com.clobot.minibasic.view.layer7_devel.DevelTabView
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update

abstract class DevelTab(private val develManager: DevelManager) {
    abstract val name: String
    abstract val develTabView: DevelTabView

    protected val logList = mutableListOf<String>()
    fun log(msg: String) {
        logList.add(msg)
        if (logList.size >= 100)
            logList.removeFirst()

        updateDevelTabView()
    }

    protected fun updateDevelTabView() {
        develManager.updateDevelTabView()
    }
}

object DevelManager {

    private val develTabList = mutableListOf<DevelTab>()
    private val develTabListView: DevelTabListView
        get() {
            return DevelTabListView(
                onIsShow = { setIsShow(false) },
                develTabList.toTypedArray(),
                selTab,
                onSelTab = { selTab = it })
        }

    private val selDevelTab: DevelTab?
        get() {
            return if (selTab >= 0 && selTab < develTabList.size)
                develTabList[selTab]
            else
                null
        }


    private var selTab = -1
        set(value) {
            field = value
            updateDevelTabListView()
            updateDevelTabView()
        }



    val generalDevelTab = GeneralDevelTab(this)
    val robotDevelTab = RobotDevelTab(this)



    init {
        develTabList.add(generalDevelTab)
        develTabList.add(robotDevelTab)
    }



    private val isShowMsf = MutableStateFlow(false)
    val isShowSf = isShowMsf.asStateFlow()
    fun setIsShow(isShow: Boolean) {
        isShowMsf.update {
            isShow
        }
    }

    private val develTabListViewMsf = MutableStateFlow(develTabListView)
    val develTabListViewSf = develTabListViewMsf.asStateFlow()
    private fun updateDevelTabListView() {
        develTabListViewMsf.update {
            develTabListView
        }
    }

    private val develTabViewMsf = MutableStateFlow(selDevelTab?.develTabView)
    val develTabViewSf = develTabViewMsf.asStateFlow()
    fun updateDevelTabView() {
        develTabViewMsf.update {
            selDevelTab?.develTabView
        }
    }

}

@Composable
fun BaseDevelScreen(develTabListView: DevelTabListView, contents: @Composable () -> Unit) {
    Surface(modifier = Modifier.fillMaxSize(), color = Color.Transparent) {
        Box(
            modifier = Modifier
                .fillMaxSize()
                .padding(10.dp)
                .background(color = Color.LightGray)
        ) {

            Column(
                modifier = Modifier
                    .fillMaxSize()
                    .padding(10.dp)
                    .border(BorderStroke(width = 0.dp, color = Color.Red))
            ) {
                Row() {
                    LazyRow(content = {
                        items(count = develTabListView.develTabArr.size) { tab ->
                            Button(
                                onClick = { develTabListView.onSelTab(tab) },
                                enabled = develTabListView.selTab != tab,
                                colors = ButtonDefaults.buttonColors(disabledContainerColor = Color.Gray)
                            ) {
                                Text(develTabListView.develTabArr[tab].name)
                            }
                        }
                    })
                }
                Box(
                    modifier = Modifier
                        .fillMaxSize()
                        .padding(10.dp)
                        .border(
                            BorderStroke(
                                width = 0.dp,
                                color = Color.Red
                            )
                        )
                )
                {
                    contents()
                }
            }
            Box(modifier = Modifier.fillMaxWidth()) {
                Button(
                    modifier = Modifier.align(Alignment.TopEnd),
                    onClick = { develTabListView.onIsShow(false) }) {
                    Text("Back")
                }
            }
        }
    }
}

@Composable
fun DevelTabScreen(develTabView: DevelTabView?) {
    if (develTabView == null)
        return
    when (develTabView) {
        is DevelTabView.General -> GeneralDevelTabScreen(develTabView)
        is DevelTabView.Robot -> RobotDevelTabScreen(develTabView)
        //is DevelTabView.Mqtt -> MqttDevelTabScreen(develTabView)
    }
}
