package com.clobot.minibasic.data.contents

import com.clobot.minibasic.data.devel.DevelManager
import com.google.gson.JsonObject

class PromoteContents {
    class PromoteContentsData {
        var staySec = 5
        var movieList = mutableListOf<String>()
        var poiList = mutableListOf<String>()

        fun load(promoteContentsJObj: JsonObject) {
            staySec = promoteContentsJObj.get("stay_sec").asInt

            movieList.clear()
            val movieListJArr = promoteContentsJObj.get("movie_list").asJsonArray
            movieListJArr.forEach {
                movieList.add(it.asString)
            }

            poiList.clear()
            val poiListJArr = promoteContentsJObj.get("poi_list").asJsonArray
            poiListJArr.forEach {
                poiList.add(it.asString)
            }
        }
    }

    var promoteContentsData: PromoteContentsData? = null

    fun load(promoteModeJObj: JsonObject) {
        if (promoteModeJObj.has("promote_contents")) {
            promoteContentsData = PromoteContentsData()
            promoteContentsData?.load(promoteModeJObj.get("promote_contents").asJsonObject)
        }
    }

}