package com.clobot.minibasic.data.contents

import com.google.gson.JsonObject

class MenuInfoContents {
    class MenuInfoContentsData {
        class SubMenuInfo(val name: String, val imageArr: List<String>)
        class MenuInfo(val name: String, val imageArr: List<String>, val subMenuInfoArr: List<SubMenuInfo>)

        var name: String = ""
        var image: String = ""

        val menuInfoList = mutableListOf<MenuInfo>()

        fun load(menuContentsJObj: JsonObject) {

            name = menuContentsJObj.get("name").asString
            image = menuContentsJObj.get("image").asString

            menuInfoList.clear()
            val menuInfoListJArr = menuContentsJObj.get("menu_info_list").asJsonArray

            menuInfoListJArr.forEach {
                val menuInfoJObj = it.asJsonObject
                val name = menuInfoJObj.get("name").asString

                val imageArr = mutableListOf<String>()
                if (menuInfoJObj.has("image_list")) {
                    val imageListJArr = menuInfoJObj.get("image_list").asJsonArray
                    imageListJArr.forEach() { imageListEle ->
                        imageArr.add(imageListEle.asString)
                    }
                }

                val subMenuInfoArr = mutableListOf<SubMenuInfo>()

                if (menuInfoJObj.has("sub_menu_info_list")) {
                    val subMenuInfoListJArr = menuInfoJObj.get("sub_menu_info_list").asJsonArray
                    subMenuInfoListJArr.forEach() { subMenuInfoEle ->
                        val subMenuInfoJObj = subMenuInfoEle.asJsonObject
                        val subName = subMenuInfoJObj.get("name").asString
                        val subImageArr = mutableListOf<String>()
                        if (subMenuInfoJObj.has("image_list")) {
                            val subImageListJArr = subMenuInfoJObj.get("image_list").asJsonArray
                            subImageListJArr.forEach() {subImageLiseEle ->
                                subImageArr.add(subImageLiseEle.asString)
                            }
                        }
                        subMenuInfoArr.add(SubMenuInfo(subName, subImageArr))
                    }
                }

                menuInfoList.add(MenuInfo(name, imageArr, subMenuInfoArr))
            }
        }
    }

    var menuInfoContentsData: MenuInfoContentsData? = null

    fun load(guideModeJObj: JsonObject) {
        if (guideModeJObj.has("menu_info_contents")) {
            menuInfoContentsData = MenuInfoContentsData()
            menuInfoContentsData?.load(guideModeJObj.get("menu_info_contents").asJsonObject)
        }
    }

}