package com.clobot.minibasic.data.contents

import com.google.gson.JsonObject

class IconInfoContents {
    class IconInfoContentsData {
        class IconInfo(val name: String, val image: String, val contentsImage: String)

        var name: String = ""
        var image: String = ""

        val iconInfoList = mutableListOf<IconInfo>()

        fun load(iconContentsJObj: JsonObject) {

            name = iconContentsJObj.get("name").asString
            image = iconContentsJObj.get("image").asString

            iconInfoList.clear()
            val iconInfoListJArr = iconContentsJObj.get("icon_info_list").asJsonArray

            iconInfoListJArr.forEach {
                val iconInfoJObj = it.asJsonObject
                val name = iconInfoJObj.get("name").asString
                val image = iconInfoJObj.get("image").asString
                val contentsImage = iconInfoJObj.get("contents_image").asString
                iconInfoList.add(IconInfo(name, image, contentsImage))
            }
        }
    }

    var iconInfoContentsData: IconInfoContentsData? = null

    fun load(guideModeJObj: JsonObject) {
        if (guideModeJObj.has("icon_info_contents")) {
            iconInfoContentsData = IconInfoContentsData()
            iconInfoContentsData?.load(guideModeJObj.get("icon_info_contents").asJsonObject)
        }
    }

}