package com.clobot.minibasic.data.contents

import com.google.gson.JsonParser
import java.lang.Exception


object ContentsManager {

    private val contents =
        """
            {
                "guide_mode" : {
                    "accompany_contents" : {
                        "name" : "동행 안내",
                        "image" : "",
                        "place_list": [
                            {
                                "name":"개발팀", "poi": "호출장소"
                            },
                            {
                                "name":"기획팀", "poi": "기회팀555" 
                            },
                            {
                                "name":"개발팀", "poi": "", 
                                "page": {
                                    "title": "개발팀",
                                    "desc" : "여기는 <h>클로봇</h> 개발실입니다.\n반갑습니다.\n안내를 시작하세요",
                                    "image" : "",
                                    "tts" : ""
                                }
                            },
                            {
                                "name":"기획팀", "poi": ""
                            },
                            {
                                "name":"개발팀", "poi": "" 
                            },
                            {
                                "name":"기획팀1", "poi": "" 
                            }
                        ]
                    },
                    "menu_info_contents" : {
                        "name" : "이용 정보",
                        "image" : "",
                        "menu_info_list" : [
                            {
                                "name":"구강내과", "image_list":[]                                                    
                            },
                            {
                                "name":"보철과", "image_list":["aaa.png", "bbb.png"]                                                    
                            },
                            {
                                "name":"구강내과", "image_list":["aaa1.png", "bbb2.png", "aaa3.png", "bbb4.png"]                                                    
                            },
                            {
                                "name":"교정과", "image_list":[],
                                "sub_menu_info_list": [
                                    {
                                        "name": "교정 진행 중\n/h해외 출국 환자/ 주의사항", "image_list":["aaa.png", "bbb.png"]                                
                                    },
                                    {
                                        "name": "/h투명 유지장치/ 주의사항", "image_list":[]                                
                                    }
                                 ]
                            },
                            {
                                "name":"구강내과", "image":"",                                                    
                                "sub_menu_info_list": [
                                    {
                                        "name": "교정 진행 중\n/h해외 출국 환자/ 주의사항", "image_list":[]                                
                                    },
                                    {
                                        "name": "교정 진행 중\n/h해외 출국 환자/ 주의사항", "image_list":[]                                
                                    },
                                    {
                                        "name": "/h투명 유지장치/ 주의사항", "image_list":[]                                
                                    }
                                 ]
                            },
                            {
                                "name":"보철과", "image_list":[]                                                    
                            },
                            {
                                "name":"보존과", "image_list":[]                                                    
                            }
                        ]
                    },
                    "icon_info_contents" : {
                        "name" : "이용 정보",
                        "image" : "",
                        "icon_info_list" : [
                            {
                                "name":"클라라 AI", "image":"", "contents_image": "a.mp4"                                                    
                            },
                            {
                                "name":"병원 소개", "image":"", "contents_image": "bbb.mp4"                                                    
                            },
                            {
                                "name":"이용 시간", "image":"", "contents_image": "aaa.png"                                                    
                            }
                        ]
                    }
                },
                "promote_mode" : {
                    "promote_contents" : {
                        "stay_sec": 3,
                        "movie_list": [
                            "ai.mp4"
                        ],
                        "poi_list" : [
                            "순찰1", "순찰2", "순찰3"
                        ]
                    }
                }
            }
        """

    fun load() {
        try {
            val rootJObj = JsonParser.parseString(contents).asJsonObject


            if (rootJObj.has("guide_mode")) {
                val guideModeJObj = rootJObj.get("guide_mode").asJsonObject
                accompanyContents.load(guideModeJObj)
                menuInfoContents.load(guideModeJObj)
                iconInfoContents.load(guideModeJObj)
            }
            if (rootJObj.has("promote_mode")) {
                val promoteModeJObj = rootJObj.get("promote_mode").asJsonObject
                promoteContents.load(promoteModeJObj)
            }

        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    val accompanyContents = AccompanyContents()
    val menuInfoContents = MenuInfoContents()
    val iconInfoContents = IconInfoContents()
    val promoteContents = PromoteContents()
}
